@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The DH Group used in IKE Phase 1 for initial SA.
 */
public enum class DhGroup(
    public val javaValue: com.pulumi.azurenative.network.enums.DhGroup,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.DhGroup> {
    None(com.pulumi.azurenative.network.enums.DhGroup.None),
    DHGroup1(com.pulumi.azurenative.network.enums.DhGroup.DHGroup1),
    DHGroup2(com.pulumi.azurenative.network.enums.DhGroup.DHGroup2),
    DHGroup14(com.pulumi.azurenative.network.enums.DhGroup.DHGroup14),
    DHGroup2048(com.pulumi.azurenative.network.enums.DhGroup.DHGroup2048),
    ECP256(com.pulumi.azurenative.network.enums.DhGroup.ECP256),
    ECP384(com.pulumi.azurenative.network.enums.DhGroup.ECP384),
    DHGroup24(com.pulumi.azurenative.network.enums.DhGroup.DHGroup24),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.DhGroup = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.DhGroup): DhGroup =
            DhGroup.values().first { it.javaValue == javaType }
    }
}
