@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The monitoring status of the endpoint.
 */
public enum class EndpointMonitorStatus(
    public val javaValue: com.pulumi.azurenative.network.enums.EndpointMonitorStatus,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.EndpointMonitorStatus> {
    CheckingEndpoint(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.CheckingEndpoint),
    Online(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.Online),
    Degraded(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.Degraded),
    Disabled(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.Disabled),
    Inactive(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.Inactive),
    Stopped(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.Stopped),
    Unmonitored(com.pulumi.azurenative.network.enums.EndpointMonitorStatus.Unmonitored),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.EndpointMonitorStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.EndpointMonitorStatus):
            EndpointMonitorStatus = EndpointMonitorStatus.values().first { it.javaValue == javaType }
    }
}
