@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
 */
public enum class EndpointStatus(
    public val javaValue: com.pulumi.azurenative.network.enums.EndpointStatus,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.EndpointStatus> {
    Enabled(com.pulumi.azurenative.network.enums.EndpointStatus.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.EndpointStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.EndpointStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.EndpointStatus):
            EndpointStatus = EndpointStatus.values().first { it.javaValue == javaType }
    }
}
