@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protocol this rule will use when forwarding traffic to backends.
 */
public enum class FrontDoorForwardingProtocol(
    public val javaValue: com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol> {
    HttpOnly(com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol.HttpOnly),
    HttpsOnly(com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol.HttpsOnly),
    MatchRequest(com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol.MatchRequest),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.FrontDoorForwardingProtocol):
            FrontDoorForwardingProtocol =
            FrontDoorForwardingProtocol.values().first { it.javaValue == javaType }
    }
}
