@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The redirect type the rule will use when redirecting traffic.
 */
public enum class FrontDoorRedirectType(
    public val javaValue: com.pulumi.azurenative.network.enums.FrontDoorRedirectType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.FrontDoorRedirectType> {
    Moved(com.pulumi.azurenative.network.enums.FrontDoorRedirectType.Moved),
    Found(com.pulumi.azurenative.network.enums.FrontDoorRedirectType.Found),
    TemporaryRedirect(com.pulumi.azurenative.network.enums.FrontDoorRedirectType.TemporaryRedirect),
    PermanentRedirect(com.pulumi.azurenative.network.enums.FrontDoorRedirectType.PermanentRedirect),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.FrontDoorRedirectType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.FrontDoorRedirectType):
            FrontDoorRedirectType = FrontDoorRedirectType.values().first { it.javaValue == javaType }
    }
}
