@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
 */
public enum class HealthProbeEnabled(
    public val javaValue: com.pulumi.azurenative.network.enums.HealthProbeEnabled,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.HealthProbeEnabled> {
    Enabled(com.pulumi.azurenative.network.enums.HealthProbeEnabled.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.HealthProbeEnabled.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.HealthProbeEnabled = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.HealthProbeEnabled):
            HealthProbeEnabled = HealthProbeEnabled.values().first { it.javaValue == javaType }
    }
}
