@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
 */
public enum class IPVersion(
    public val javaValue: com.pulumi.azurenative.network.enums.IPVersion,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.IPVersion> {
    IPv4(com.pulumi.azurenative.network.enums.IPVersion.IPv4),
    IPv6(com.pulumi.azurenative.network.enums.IPVersion.IPv6),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.IPVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.IPVersion): IPVersion =
            IPVersion.values().first { it.javaValue == javaType }
    }
}
