@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Pfs Group used in IKE Phase 2 for new child SA.
 */
public enum class PfsGroup(
    public val javaValue: com.pulumi.azurenative.network.enums.PfsGroup,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.PfsGroup> {
    None(com.pulumi.azurenative.network.enums.PfsGroup.None),
    PFS1(com.pulumi.azurenative.network.enums.PfsGroup.PFS1),
    PFS2(com.pulumi.azurenative.network.enums.PfsGroup.PFS2),
    PFS2048(com.pulumi.azurenative.network.enums.PfsGroup.PFS2048),
    ECP256(com.pulumi.azurenative.network.enums.PfsGroup.ECP256),
    ECP384(com.pulumi.azurenative.network.enums.PfsGroup.ECP384),
    PFS24(com.pulumi.azurenative.network.enums.PfsGroup.PFS24),
    PFS14(com.pulumi.azurenative.network.enums.PfsGroup.PFS14),
    PFSMM(com.pulumi.azurenative.network.enums.PfsGroup.PFSMM),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.PfsGroup = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.PfsGroup): PfsGroup =
            PfsGroup.values().first { it.javaValue == javaType }
    }
}
