@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
 */
public enum class PolicyEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.PolicyEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.PolicyEnabledState> {
    Disabled(com.pulumi.azurenative.network.enums.PolicyEnabledState.Disabled),
    Enabled(com.pulumi.azurenative.network.enums.PolicyEnabledState.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.PolicyEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.PolicyEnabledState):
            PolicyEnabledState = PolicyEnabledState.values().first { it.javaValue == javaType }
    }
}
