@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The domain name label scope. If a domain name label and a domain name label scope are specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system with a hashed value includes in FQDN.
 */
public enum class PublicIpAddressDnsSettingsDomainNameLabelScope(
    public val javaValue:
    com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope> {
    TenantReuse(com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope.TenantReuse),
    SubscriptionReuse(com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope.SubscriptionReuse),
    ResourceGroupReuse(com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope.ResourceGroupReuse),
    NoReuse(com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope.NoReuse),
    ;

    override fun toJava():
        com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.enums.PublicIpAddressDnsSettingsDomainNameLabelScope):
            PublicIpAddressDnsSettingsDomainNameLabelScope =
            PublicIpAddressDnsSettingsDomainNameLabelScope.values().first { it.javaValue == javaType }
    }
}
