@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
 */
public enum class SecurityRuleDirection(
    public val javaValue: com.pulumi.azurenative.network.enums.SecurityRuleDirection,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.SecurityRuleDirection> {
    Inbound(com.pulumi.azurenative.network.enums.SecurityRuleDirection.Inbound),
    Outbound(com.pulumi.azurenative.network.enums.SecurityRuleDirection.Outbound),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.SecurityRuleDirection = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.SecurityRuleDirection):
            SecurityRuleDirection = SecurityRuleDirection.values().first { it.javaValue == javaType }
    }
}
