@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The state of the Experiment
 */
public enum class State(
    public val javaValue: com.pulumi.azurenative.network.enums.State,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.State> {
    Enabled(com.pulumi.azurenative.network.enums.State.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.State.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.State = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.State): State =
            State.values().first { it.javaValue == javaType }
    }
}
