@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
 */
public enum class TrafficViewEnrollmentStatus(
    public val javaValue: com.pulumi.azurenative.network.enums.TrafficViewEnrollmentStatus,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.TrafficViewEnrollmentStatus> {
    Enabled(com.pulumi.azurenative.network.enums.TrafficViewEnrollmentStatus.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.TrafficViewEnrollmentStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.TrafficViewEnrollmentStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.TrafficViewEnrollmentStatus):
            TrafficViewEnrollmentStatus =
            TrafficViewEnrollmentStatus.values().first { it.javaValue == javaType }
    }
}
