@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ARecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An A record.
 * @property ipv4Address The IPv4 address of this A record.
 */
public data class ARecordArgs(
    public val ipv4Address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ARecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ARecordArgs =
        com.pulumi.azurenative.network.inputs.ARecordArgs.builder()
            .ipv4Address(ipv4Address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ARecordArgs].
 */
@PulumiTagMarker
public class ARecordArgsBuilder internal constructor() {
    private var ipv4Address: Output<String>? = null

    /**
     * @param value The IPv4 address of this A record.
     */
    @JvmName("puakaaiaojotoyka")
    public suspend fun ipv4Address(`value`: Output<String>) {
        this.ipv4Address = value
    }

    /**
     * @param value The IPv4 address of this A record.
     */
    @JvmName("puylhyfjwgllqddp")
    public suspend fun ipv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Address = mapped
    }

    internal fun build(): ARecordArgs = ARecordArgs(
        ipv4Address = ipv4Address,
    )
}
