@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayAutoscaleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application Gateway autoscale configuration.
 * @property maxCapacity Upper bound on number of Application Gateway capacity.
 * @property minCapacity Lower bound on number of Application Gateway capacity.
 */
public data class ApplicationGatewayAutoscaleConfigurationArgs(
    public val maxCapacity: Output<Int>? = null,
    public val minCapacity: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayAutoscaleConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayAutoscaleConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayAutoscaleConfigurationArgs.builder()
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayAutoscaleConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayAutoscaleConfigurationArgsBuilder internal constructor() {
    private var maxCapacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    /**
     * @param value Upper bound on number of Application Gateway capacity.
     */
    @JvmName("gllmuvrgwuqtqlod")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value Lower bound on number of Application Gateway capacity.
     */
    @JvmName("tqsrmwqeiodurjog")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Upper bound on number of Application Gateway capacity.
     */
    @JvmName("ncnkjbglomsvujea")
    public suspend fun maxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Lower bound on number of Application Gateway capacity.
     */
    @JvmName("jxetpjhfcbwkfvpb")
    public suspend fun minCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ApplicationGatewayAutoscaleConfigurationArgs =
        ApplicationGatewayAutoscaleConfigurationArgs(
            maxCapacity = maxCapacity,
            minCapacity = minCapacity ?: throw PulumiNullFieldException("minCapacity"),
        )
}
