@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayCustomErrorArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayCustomErrorStatusCode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom error of an application gateway.
 * @property customErrorPageUrl Error page URL of the application gateway custom error.
 * @property statusCode Status code of the application gateway custom error.
 */
public data class ApplicationGatewayCustomErrorArgs(
    public val customErrorPageUrl: Output<String>? = null,
    public val statusCode: Output<Either<String, ApplicationGatewayCustomErrorStatusCode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayCustomErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayCustomErrorArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayCustomErrorArgs.builder()
            .customErrorPageUrl(customErrorPageUrl?.applyValue({ args0 -> args0 }))
            .statusCode(
                statusCode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayCustomErrorArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayCustomErrorArgsBuilder internal constructor() {
    private var customErrorPageUrl: Output<String>? = null

    private var statusCode: Output<Either<String, ApplicationGatewayCustomErrorStatusCode>>? = null

    /**
     * @param value Error page URL of the application gateway custom error.
     */
    @JvmName("urcmxwsewsakgggo")
    public suspend fun customErrorPageUrl(`value`: Output<String>) {
        this.customErrorPageUrl = value
    }

    /**
     * @param value Status code of the application gateway custom error.
     */
    @JvmName("phjrajmmvpwnxwix")
    public suspend
    fun statusCode(`value`: Output<Either<String, ApplicationGatewayCustomErrorStatusCode>>) {
        this.statusCode = value
    }

    /**
     * @param value Error page URL of the application gateway custom error.
     */
    @JvmName("obfdkgthrchisljg")
    public suspend fun customErrorPageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customErrorPageUrl = mapped
    }

    /**
     * @param value Status code of the application gateway custom error.
     */
    @JvmName("dekwsskbckbodcmk")
    public suspend fun statusCode(`value`: Either<String, ApplicationGatewayCustomErrorStatusCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    /**
     * @param value Status code of the application gateway custom error.
     */
    @JvmName("ehtvcaglsdvbbfmu")
    public fun statusCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayCustomErrorStatusCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    /**
     * @param value Status code of the application gateway custom error.
     */
    @JvmName("bohqusdbgisclloi")
    public fun statusCode(`value`: ApplicationGatewayCustomErrorStatusCode) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayCustomErrorStatusCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ApplicationGatewayCustomErrorArgs = ApplicationGatewayCustomErrorArgs(
        customErrorPageUrl = customErrorPageUrl,
        statusCode = statusCode,
    )
}
