@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendIPConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Frontend IP configuration of an application gateway.
 * @property id Resource ID.
 * @property name Name of the frontend IP configuration that is unique within an Application Gateway.
 * @property privateIPAddress PrivateIPAddress of the network interface IP Configuration.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property privateLinkConfiguration Reference to the application gateway private link configuration.
 * @property publicIPAddress Reference to the PublicIP resource.
 * @property subnet Reference to the subnet resource.
 */
public data class ApplicationGatewayFrontendIPConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val privateLinkConfiguration: Output<SubResourceArgs>? = null,
    public val publicIPAddress: Output<SubResourceArgs>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendIPConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendIPConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkConfiguration(
                privateLinkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayFrontendIPConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayFrontendIPConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var privateLinkConfiguration: Output<SubResourceArgs>? = null

    private var publicIPAddress: Output<SubResourceArgs>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("faiokmpljwukvjqr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the frontend IP configuration that is unique within an Application Gateway.
     */
    @JvmName("dnhxmpwmacpiyjdn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value PrivateIPAddress of the network interface IP Configuration.
     */
    @JvmName("xhlqgvjpobdhgtrx")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("sxcyrcqxvkymqorv")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value Reference to the application gateway private link configuration.
     */
    @JvmName("pgibsuiiujyljlfh")
    public suspend fun privateLinkConfiguration(`value`: Output<SubResourceArgs>) {
        this.privateLinkConfiguration = value
    }

    /**
     * @param value Reference to the PublicIP resource.
     */
    @JvmName("filyrkhnpgmiktxv")
    public suspend fun publicIPAddress(`value`: Output<SubResourceArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value Reference to the subnet resource.
     */
    @JvmName("dvbiunmuttbasimx")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("adybwkqnpjicogvh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the frontend IP configuration that is unique within an Application Gateway.
     */
    @JvmName("qeerdcqrvspvxtsc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value PrivateIPAddress of the network interface IP Configuration.
     */
    @JvmName("cpsxoghmtfnbkmmr")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("xmaaxxqddjhjqirk")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("hafkxmbolvmmgisc")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("fsiugoskcmumihcs")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Reference to the application gateway private link configuration.
     */
    @JvmName("ttgsfujyywrdmcdh")
    public suspend fun privateLinkConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkConfiguration = mapped
    }

    /**
     * @param argument Reference to the application gateway private link configuration.
     */
    @JvmName("fuhchafsejomisty")
    public suspend fun privateLinkConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkConfiguration = mapped
    }

    /**
     * @param value Reference to the PublicIP resource.
     */
    @JvmName("lmxyjwgetbifvrvt")
    public suspend fun publicIPAddress(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument Reference to the PublicIP resource.
     */
    @JvmName("mnwgebkbbttsvruh")
    public suspend fun publicIPAddress(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value Reference to the subnet resource.
     */
    @JvmName("tbwbkmwtejplynss")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Reference to the subnet resource.
     */
    @JvmName("yoysxdkrkyxpiflt")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): ApplicationGatewayFrontendIPConfigurationArgs =
        ApplicationGatewayFrontendIPConfigurationArgs(
            id = id,
            name = name,
            privateIPAddress = privateIPAddress,
            privateIPAllocationMethod = privateIPAllocationMethod,
            privateLinkConfiguration = privateLinkConfiguration,
            publicIPAddress = publicIPAddress,
            subnet = subnet,
        )
}
