@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendPortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Frontend port of an application gateway.
 * @property id Resource ID.
 * @property name Name of the frontend port that is unique within an Application Gateway.
 * @property port Frontend port.
 */
public data class ApplicationGatewayFrontendPortArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendPortArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendPortArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayFrontendPortArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayFrontendPortArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayFrontendPortArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("bpystrjwcobtvvvk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the frontend port that is unique within an Application Gateway.
     */
    @JvmName("pttfwviynmqqyjtc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Frontend port.
     */
    @JvmName("hkqvwoidaiaafxew")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("frnykspamrahbrat")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the frontend port that is unique within an Application Gateway.
     */
    @JvmName("bbdwakblgywtbxfn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Frontend port.
     */
    @JvmName("siorvvdlyuynwbef")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ApplicationGatewayFrontendPortArgs = ApplicationGatewayFrontendPortArgs(
        id = id,
        name = name,
        port = port,
    )
}
