@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Http listener of an application gateway.
 * @property customErrorConfigurations Custom error configurations of the HTTP listener.
 * @property firewallPolicy Reference to the FirewallPolicy resource.
 * @property frontendIPConfiguration Frontend IP configuration resource of an application gateway.
 * @property frontendPort Frontend port resource of an application gateway.
 * @property hostName Host name of HTTP listener.
 * @property hostNames List of Host names for HTTP Listener that allows special wildcard characters as well.
 * @property id Resource ID.
 * @property name Name of the HTTP listener that is unique within an Application Gateway.
 * @property protocol Protocol of the HTTP listener.
 * @property requireServerNameIndication Applicable only if protocol is https. Enables SNI for multi-hosting.
 * @property sslCertificate SSL certificate resource of an application gateway.
 * @property sslProfile SSL profile resource of the application gateway.
 */
public data class ApplicationGatewayHttpListenerArgs(
    public val customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorArgs>>? = null,
    public val firewallPolicy: Output<SubResourceArgs>? = null,
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPort: Output<SubResourceArgs>? = null,
    public val hostName: Output<String>? = null,
    public val hostNames: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null,
    public val requireServerNameIndication: Output<Boolean>? = null,
    public val sslCertificate: Output<SubResourceArgs>? = null,
    public val sslProfile: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs.builder()
            .customErrorConfigurations(
                customErrorConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .firewallPolicy(firewallPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPort(frontendPort?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .hostNames(hostNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requireServerNameIndication(requireServerNameIndication?.applyValue({ args0 -> args0 }))
            .sslCertificate(sslCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sslProfile(sslProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayHttpListenerArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayHttpListenerArgsBuilder internal constructor() {
    private var customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorArgs>>? = null

    private var firewallPolicy: Output<SubResourceArgs>? = null

    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPort: Output<SubResourceArgs>? = null

    private var hostName: Output<String>? = null

    private var hostNames: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null

    private var requireServerNameIndication: Output<Boolean>? = null

    private var sslCertificate: Output<SubResourceArgs>? = null

    private var sslProfile: Output<SubResourceArgs>? = null

    /**
     * @param value Custom error configurations of the HTTP listener.
     */
    @JvmName("gtnaqkwtcwdeuleh")
    public suspend
    fun customErrorConfigurations(`value`: Output<List<ApplicationGatewayCustomErrorArgs>>) {
        this.customErrorConfigurations = value
    }

    @JvmName("miafkwqyuajrykbf")
    public suspend fun customErrorConfigurations(
        vararg
        values: Output<ApplicationGatewayCustomErrorArgs>,
    ) {
        this.customErrorConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Custom error configurations of the HTTP listener.
     */
    @JvmName("ndfduawrikgngudp")
    public suspend
    fun customErrorConfigurations(values: List<Output<ApplicationGatewayCustomErrorArgs>>) {
        this.customErrorConfigurations = Output.all(values)
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("wcexgtmobwtkybci")
    public suspend fun firewallPolicy(`value`: Output<SubResourceArgs>) {
        this.firewallPolicy = value
    }

    /**
     * @param value Frontend IP configuration resource of an application gateway.
     */
    @JvmName("vytdvttnevahqgfv")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value Frontend port resource of an application gateway.
     */
    @JvmName("koqwjbaujsgiffrh")
    public suspend fun frontendPort(`value`: Output<SubResourceArgs>) {
        this.frontendPort = value
    }

    /**
     * @param value Host name of HTTP listener.
     */
    @JvmName("uwjnwiadxrrwhbxc")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("utiilalbfmuldwmt")
    public suspend fun hostNames(`value`: Output<List<String>>) {
        this.hostNames = value
    }

    @JvmName("flpnoagrglrlmwow")
    public suspend fun hostNames(vararg values: Output<String>) {
        this.hostNames = Output.all(values.asList())
    }

    /**
     * @param values List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("qlvsmmimudvedtbb")
    public suspend fun hostNames(values: List<Output<String>>) {
        this.hostNames = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tqjuywlpqbxlvxrn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the HTTP listener that is unique within an Application Gateway.
     */
    @JvmName("qevdtnsuuvabbrlt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("nwtuluuvqyqhuwtm")
    public suspend fun protocol(`value`: Output<Either<String, ApplicationGatewayProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Applicable only if protocol is https. Enables SNI for multi-hosting.
     */
    @JvmName("tebrhfxghbnsfnuq")
    public suspend fun requireServerNameIndication(`value`: Output<Boolean>) {
        this.requireServerNameIndication = value
    }

    /**
     * @param value SSL certificate resource of an application gateway.
     */
    @JvmName("mxmuvmuujongkyhs")
    public suspend fun sslCertificate(`value`: Output<SubResourceArgs>) {
        this.sslCertificate = value
    }

    /**
     * @param value SSL profile resource of the application gateway.
     */
    @JvmName("alkwijyxthgtxnkc")
    public suspend fun sslProfile(`value`: Output<SubResourceArgs>) {
        this.sslProfile = value
    }

    /**
     * @param value Custom error configurations of the HTTP listener.
     */
    @JvmName("jordtymavboqjkaj")
    public suspend fun customErrorConfigurations(`value`: List<ApplicationGatewayCustomErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the HTTP listener.
     */
    @JvmName("vdmbprgictjqmrid")
    public suspend
    fun customErrorConfigurations(argument: List<suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the HTTP listener.
     */
    @JvmName("dnshakhwblngbxea")
    public suspend fun customErrorConfigurations(
        vararg
        argument: suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the HTTP listener.
     */
    @JvmName("mmpnblqtwirfmgul")
    public suspend
    fun customErrorConfigurations(argument: suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param values Custom error configurations of the HTTP listener.
     */
    @JvmName("uycfshejpvxvcsfy")
    public suspend fun customErrorConfigurations(vararg values: ApplicationGatewayCustomErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customErrorConfigurations = mapped
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("nidybkhcvqasyovl")
    public suspend fun firewallPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicy = mapped
    }

    /**
     * @param argument Reference to the FirewallPolicy resource.
     */
    @JvmName("nxjkxuoofsdwsxok")
    public suspend fun firewallPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallPolicy = mapped
    }

    /**
     * @param value Frontend IP configuration resource of an application gateway.
     */
    @JvmName("mwlfjsujsodecutj")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument Frontend IP configuration resource of an application gateway.
     */
    @JvmName("xmfkqetnsgmycmiq")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value Frontend port resource of an application gateway.
     */
    @JvmName("hgapofbsxqvpncmh")
    public suspend fun frontendPort(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param argument Frontend port resource of an application gateway.
     */
    @JvmName("bxvhtvhntsqtaiqs")
    public suspend fun frontendPort(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendPort = mapped
    }

    /**
     * @param value Host name of HTTP listener.
     */
    @JvmName("xsbhipauoeotknnv")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("edmaedraiftbtkug")
    public suspend fun hostNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNames = mapped
    }

    /**
     * @param values List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("pbwsbhyrjgqvgrgo")
    public suspend fun hostNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostNames = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qsylocbhyvgthunr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the HTTP listener that is unique within an Application Gateway.
     */
    @JvmName("cmgsrfxvfsknredo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("rputokimxwripnml")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("jbmvtjnrwambsgiw")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("wytkrsirwstiikxn")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Applicable only if protocol is https. Enables SNI for multi-hosting.
     */
    @JvmName("sxlkxyercyrvifuq")
    public suspend fun requireServerNameIndication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireServerNameIndication = mapped
    }

    /**
     * @param value SSL certificate resource of an application gateway.
     */
    @JvmName("kpuhcdielswcsbjs")
    public suspend fun sslCertificate(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificate = mapped
    }

    /**
     * @param argument SSL certificate resource of an application gateway.
     */
    @JvmName("loetsnbrstfbnnio")
    public suspend fun sslCertificate(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslCertificate = mapped
    }

    /**
     * @param value SSL profile resource of the application gateway.
     */
    @JvmName("qmtoggfmgbjbnoai")
    public suspend fun sslProfile(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProfile = mapped
    }

    /**
     * @param argument SSL profile resource of the application gateway.
     */
    @JvmName("yfftvknylqvnbdpl")
    public suspend fun sslProfile(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslProfile = mapped
    }

    internal fun build(): ApplicationGatewayHttpListenerArgs = ApplicationGatewayHttpListenerArgs(
        customErrorConfigurations = customErrorConfigurations,
        firewallPolicy = firewallPolicy,
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPort = frontendPort,
        hostName = hostName,
        hostNames = hostNames,
        id = id,
        name = name,
        protocol = protocol,
        requireServerNameIndication = requireServerNameIndication,
        sslCertificate = sslCertificate,
        sslProfile = sslProfile,
    )
}
