@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRedirectConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayRedirectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Redirect configuration of an application gateway.
 * @property id Resource ID.
 * @property includePath Include path in the redirected url.
 * @property includeQueryString Include query string in the redirected url.
 * @property name Name of the redirect configuration that is unique within an Application Gateway.
 * @property pathRules Path rules specifying redirect configuration.
 * @property redirectType HTTP redirection type.
 * @property requestRoutingRules Request routing specifying redirect configuration.
 * @property targetListener Reference to a listener to redirect the request to.
 * @property targetUrl Url to redirect the request to.
 * @property urlPathMaps Url path maps specifying default redirect configuration.
 */
public data class ApplicationGatewayRedirectConfigurationArgs(
    public val id: Output<String>? = null,
    public val includePath: Output<Boolean>? = null,
    public val includeQueryString: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val pathRules: Output<List<SubResourceArgs>>? = null,
    public val redirectType: Output<Either<String, ApplicationGatewayRedirectType>>? = null,
    public val requestRoutingRules: Output<List<SubResourceArgs>>? = null,
    public val targetListener: Output<SubResourceArgs>? = null,
    public val targetUrl: Output<String>? = null,
    public val urlPathMaps: Output<List<SubResourceArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRedirectConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRedirectConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRedirectConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .includePath(includePath?.applyValue({ args0 -> args0 }))
            .includeQueryString(includeQueryString?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .pathRules(
                pathRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .redirectType(
                redirectType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requestRoutingRules(
                requestRoutingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetListener(targetListener?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetUrl(targetUrl?.applyValue({ args0 -> args0 }))
            .urlPathMaps(
                urlPathMaps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayRedirectConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRedirectConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var includePath: Output<Boolean>? = null

    private var includeQueryString: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var pathRules: Output<List<SubResourceArgs>>? = null

    private var redirectType: Output<Either<String, ApplicationGatewayRedirectType>>? = null

    private var requestRoutingRules: Output<List<SubResourceArgs>>? = null

    private var targetListener: Output<SubResourceArgs>? = null

    private var targetUrl: Output<String>? = null

    private var urlPathMaps: Output<List<SubResourceArgs>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ithiohyhothrkdbk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Include path in the redirected url.
     */
    @JvmName("tibnxrcxmqifcinh")
    public suspend fun includePath(`value`: Output<Boolean>) {
        this.includePath = value
    }

    /**
     * @param value Include query string in the redirected url.
     */
    @JvmName("pngbmebpcxhnwukt")
    public suspend fun includeQueryString(`value`: Output<Boolean>) {
        this.includeQueryString = value
    }

    /**
     * @param value Name of the redirect configuration that is unique within an Application Gateway.
     */
    @JvmName("ivuyxmegnsdvjnve")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Path rules specifying redirect configuration.
     */
    @JvmName("wwbjcldomayyflif")
    public suspend fun pathRules(`value`: Output<List<SubResourceArgs>>) {
        this.pathRules = value
    }

    @JvmName("viivoulpmlodmtrs")
    public suspend fun pathRules(vararg values: Output<SubResourceArgs>) {
        this.pathRules = Output.all(values.asList())
    }

    /**
     * @param values Path rules specifying redirect configuration.
     */
    @JvmName("ktryjhregixonhog")
    public suspend fun pathRules(values: List<Output<SubResourceArgs>>) {
        this.pathRules = Output.all(values)
    }

    /**
     * @param value HTTP redirection type.
     */
    @JvmName("vicstgmeatpvjvmn")
    public suspend fun redirectType(`value`: Output<Either<String, ApplicationGatewayRedirectType>>) {
        this.redirectType = value
    }

    /**
     * @param value Request routing specifying redirect configuration.
     */
    @JvmName("tdnxspgwnyvqvvad")
    public suspend fun requestRoutingRules(`value`: Output<List<SubResourceArgs>>) {
        this.requestRoutingRules = value
    }

    @JvmName("dfriypfkepmsfdbb")
    public suspend fun requestRoutingRules(vararg values: Output<SubResourceArgs>) {
        this.requestRoutingRules = Output.all(values.asList())
    }

    /**
     * @param values Request routing specifying redirect configuration.
     */
    @JvmName("boiyqyysqksrwrnh")
    public suspend fun requestRoutingRules(values: List<Output<SubResourceArgs>>) {
        this.requestRoutingRules = Output.all(values)
    }

    /**
     * @param value Reference to a listener to redirect the request to.
     */
    @JvmName("eoexpwfucokrxjbm")
    public suspend fun targetListener(`value`: Output<SubResourceArgs>) {
        this.targetListener = value
    }

    /**
     * @param value Url to redirect the request to.
     */
    @JvmName("onjuwrcsfxmidvjg")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value Url path maps specifying default redirect configuration.
     */
    @JvmName("lctgpvfkswaodnpk")
    public suspend fun urlPathMaps(`value`: Output<List<SubResourceArgs>>) {
        this.urlPathMaps = value
    }

    @JvmName("jiiidjxrcxuefiak")
    public suspend fun urlPathMaps(vararg values: Output<SubResourceArgs>) {
        this.urlPathMaps = Output.all(values.asList())
    }

    /**
     * @param values Url path maps specifying default redirect configuration.
     */
    @JvmName("xwcyydegdgiobaxc")
    public suspend fun urlPathMaps(values: List<Output<SubResourceArgs>>) {
        this.urlPathMaps = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vpccdfuxhcadmkba")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Include path in the redirected url.
     */
    @JvmName("koosniprmtglyxaw")
    public suspend fun includePath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includePath = mapped
    }

    /**
     * @param value Include query string in the redirected url.
     */
    @JvmName("naxtgtxncrwetbne")
    public suspend fun includeQueryString(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeQueryString = mapped
    }

    /**
     * @param value Name of the redirect configuration that is unique within an Application Gateway.
     */
    @JvmName("jocpsgrdhtoytiop")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Path rules specifying redirect configuration.
     */
    @JvmName("kcrxlyoyeaspgyxm")
    public suspend fun pathRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathRules = mapped
    }

    /**
     * @param argument Path rules specifying redirect configuration.
     */
    @JvmName("gnbowixmrqyxyyxt")
    public suspend fun pathRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.pathRules = mapped
    }

    /**
     * @param argument Path rules specifying redirect configuration.
     */
    @JvmName("nveutdfdlaeopeae")
    public suspend fun pathRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.pathRules = mapped
    }

    /**
     * @param argument Path rules specifying redirect configuration.
     */
    @JvmName("fovkvjvdrduiaksv")
    public suspend fun pathRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pathRules = mapped
    }

    /**
     * @param values Path rules specifying redirect configuration.
     */
    @JvmName("elupxdmmamqxnttq")
    public suspend fun pathRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pathRules = mapped
    }

    /**
     * @param value HTTP redirection type.
     */
    @JvmName("kklssvqcdllokpdx")
    public suspend fun redirectType(`value`: Either<String, ApplicationGatewayRedirectType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value HTTP redirection type.
     */
    @JvmName("ipgynsqdqsucobog")
    public fun redirectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayRedirectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value HTTP redirection type.
     */
    @JvmName("pithkywqxdnostlh")
    public fun redirectType(`value`: ApplicationGatewayRedirectType) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayRedirectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value Request routing specifying redirect configuration.
     */
    @JvmName("dwvladxjaoiapmfr")
    public suspend fun requestRoutingRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestRoutingRules = mapped
    }

    /**
     * @param argument Request routing specifying redirect configuration.
     */
    @JvmName("ihdlcxxqndkwjyok")
    public suspend
    fun requestRoutingRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.requestRoutingRules = mapped
    }

    /**
     * @param argument Request routing specifying redirect configuration.
     */
    @JvmName("urqoakfybuacdhvg")
    public suspend fun requestRoutingRules(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.requestRoutingRules = mapped
    }

    /**
     * @param argument Request routing specifying redirect configuration.
     */
    @JvmName("mvrrkkqbxwnvxgsb")
    public suspend fun requestRoutingRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.requestRoutingRules = mapped
    }

    /**
     * @param values Request routing specifying redirect configuration.
     */
    @JvmName("cvvejorisslcptcv")
    public suspend fun requestRoutingRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestRoutingRules = mapped
    }

    /**
     * @param value Reference to a listener to redirect the request to.
     */
    @JvmName("bivqibmjwrtgcxki")
    public suspend fun targetListener(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetListener = mapped
    }

    /**
     * @param argument Reference to a listener to redirect the request to.
     */
    @JvmName("adxbutagikdodqhr")
    public suspend fun targetListener(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetListener = mapped
    }

    /**
     * @param value Url to redirect the request to.
     */
    @JvmName("tillevkdhymjmjqc")
    public suspend fun targetUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value Url path maps specifying default redirect configuration.
     */
    @JvmName("kegdbetyrabevxdn")
    public suspend fun urlPathMaps(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlPathMaps = mapped
    }

    /**
     * @param argument Url path maps specifying default redirect configuration.
     */
    @JvmName("lpgxuhxognxmmubq")
    public suspend fun urlPathMaps(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.urlPathMaps = mapped
    }

    /**
     * @param argument Url path maps specifying default redirect configuration.
     */
    @JvmName("xhfummidjyutvrfl")
    public suspend fun urlPathMaps(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.urlPathMaps = mapped
    }

    /**
     * @param argument Url path maps specifying default redirect configuration.
     */
    @JvmName("lmvdsqhmuorwcmgv")
    public suspend fun urlPathMaps(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.urlPathMaps = mapped
    }

    /**
     * @param values Url path maps specifying default redirect configuration.
     */
    @JvmName("eqlvdanwlsilojrd")
    public suspend fun urlPathMaps(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlPathMaps = mapped
    }

    internal fun build(): ApplicationGatewayRedirectConfigurationArgs =
        ApplicationGatewayRedirectConfigurationArgs(
            id = id,
            includePath = includePath,
            includeQueryString = includeQueryString,
            name = name,
            pathRules = pathRules,
            redirectType = redirectType,
            requestRoutingRules = requestRoutingRules,
            targetListener = targetListener,
            targetUrl = targetUrl,
            urlPathMaps = urlPathMaps,
        )
}
