@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRoutingRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayRequestRoutingRuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Routing rule of an application gateway.
 * @property backendAddressPool Backend address pool resource of the application gateway.
 * @property backendSettings Backend settings resource of the application gateway.
 * @property id Resource ID.
 * @property listener Listener resource of the application gateway.
 * @property name Name of the routing rule that is unique within an Application Gateway.
 * @property priority Priority of the routing rule.
 * @property ruleType Rule type.
 */
public data class ApplicationGatewayRoutingRuleArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val backendSettings: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val listener: Output<SubResourceArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>,
    public val ruleType: Output<Either<String, ApplicationGatewayRequestRoutingRuleType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRoutingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayRoutingRuleArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRoutingRuleArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendSettings(backendSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .listener(listener?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .ruleType(
                ruleType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayRoutingRuleArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRoutingRuleArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var backendSettings: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var listener: Output<SubResourceArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleType: Output<Either<String, ApplicationGatewayRequestRoutingRuleType>>? = null

    /**
     * @param value Backend address pool resource of the application gateway.
     */
    @JvmName("wpmghbkhixcpyoxr")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value Backend settings resource of the application gateway.
     */
    @JvmName("ybuyykdxnxrnqcwd")
    public suspend fun backendSettings(`value`: Output<SubResourceArgs>) {
        this.backendSettings = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dubyrxamfpixdusa")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Listener resource of the application gateway.
     */
    @JvmName("qtguwduqnbdyumfl")
    public suspend fun listener(`value`: Output<SubResourceArgs>) {
        this.listener = value
    }

    /**
     * @param value Name of the routing rule that is unique within an Application Gateway.
     */
    @JvmName("hlgcajoxfarjlivc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the routing rule.
     */
    @JvmName("nbwkgyolnrxaroho")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Rule type.
     */
    @JvmName("gqvkthlybbyunrmq")
    public suspend
    fun ruleType(`value`: Output<Either<String, ApplicationGatewayRequestRoutingRuleType>>) {
        this.ruleType = value
    }

    /**
     * @param value Backend address pool resource of the application gateway.
     */
    @JvmName("jbrebldtceqbsunq")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument Backend address pool resource of the application gateway.
     */
    @JvmName("iqohycdyqvlhbyob")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value Backend settings resource of the application gateway.
     */
    @JvmName("dfafwgtwbqbfuwlp")
    public suspend fun backendSettings(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendSettings = mapped
    }

    /**
     * @param argument Backend settings resource of the application gateway.
     */
    @JvmName("txhfulojurmxclto")
    public suspend fun backendSettings(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendSettings = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mrulmljgantgnitk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Listener resource of the application gateway.
     */
    @JvmName("qpwwnqlxjgnngtid")
    public suspend fun listener(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listener = mapped
    }

    /**
     * @param argument Listener resource of the application gateway.
     */
    @JvmName("ioroxibqpamwkvkk")
    public suspend fun listener(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.listener = mapped
    }

    /**
     * @param value Name of the routing rule that is unique within an Application Gateway.
     */
    @JvmName("lmncquecdwhcpgjg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the routing rule.
     */
    @JvmName("hdgpbnorqjgpxtxo")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Rule type.
     */
    @JvmName("bcquccwseplargny")
    public suspend fun ruleType(`value`: Either<String, ApplicationGatewayRequestRoutingRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Rule type.
     */
    @JvmName("ekmghpfkffvguwby")
    public fun ruleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayRequestRoutingRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Rule type.
     */
    @JvmName("aofwebcrahqtwdpw")
    public fun ruleType(`value`: ApplicationGatewayRequestRoutingRuleType) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayRequestRoutingRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    internal fun build(): ApplicationGatewayRoutingRuleArgs = ApplicationGatewayRoutingRuleArgs(
        backendAddressPool = backendAddressPool,
        backendSettings = backendSettings,
        id = id,
        listener = listener,
        name = name,
        priority = priority ?: throw PulumiNullFieldException("priority"),
        ruleType = ruleType,
    )
}
