@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewaySkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySkuName
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of an application gateway.
 * @property capacity Capacity (instance count) of an application gateway.
 * @property name Name of an application gateway SKU.
 * @property tier Tier of an application gateway.
 */
public data class ApplicationGatewaySkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, ApplicationGatewaySkuName>>? = null,
    public val tier: Output<Either<String, ApplicationGatewayTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewaySkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewaySkuArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewaySkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewaySkuArgs].
 */
@PulumiTagMarker
public class ApplicationGatewaySkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, ApplicationGatewaySkuName>>? = null

    private var tier: Output<Either<String, ApplicationGatewayTier>>? = null

    /**
     * @param value Capacity (instance count) of an application gateway.
     */
    @JvmName("illwmissujfmkunl")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of an application gateway SKU.
     */
    @JvmName("wlisioadyfdgvsea")
    public suspend fun name(`value`: Output<Either<String, ApplicationGatewaySkuName>>) {
        this.name = value
    }

    /**
     * @param value Tier of an application gateway.
     */
    @JvmName("wtjhcmrierkwpcpk")
    public suspend fun tier(`value`: Output<Either<String, ApplicationGatewayTier>>) {
        this.tier = value
    }

    /**
     * @param value Capacity (instance count) of an application gateway.
     */
    @JvmName("pnxjievdberswlbh")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of an application gateway SKU.
     */
    @JvmName("smclaasyjoxwgroe")
    public suspend fun name(`value`: Either<String, ApplicationGatewaySkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an application gateway SKU.
     */
    @JvmName("njxrhrhfyhxarxys")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an application gateway SKU.
     */
    @JvmName("eysypswqseipjuuo")
    public fun name(`value`: ApplicationGatewaySkuName) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of an application gateway.
     */
    @JvmName("unyafekuhklknxvy")
    public suspend fun tier(`value`: Either<String, ApplicationGatewayTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of an application gateway.
     */
    @JvmName("oobkgowfatfmnjir")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of an application gateway.
     */
    @JvmName("gqiscwmiyffckcci")
    public fun tier(`value`: ApplicationGatewayTier) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ApplicationGatewaySkuArgs = ApplicationGatewaySkuArgs(
        capacity = capacity,
        name = name,
        tier = tier,
    )
}
