@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewaySslCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSL certificates of an application gateway.
 * @property data Base-64 encoded pfx certificate. Only applicable in PUT Request.
 * @property id Resource ID.
 * @property keyVaultSecretId Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
 * @property name Name of the SSL certificate that is unique within an Application Gateway.
 * @property password Password for the pfx file specified in data. Only applicable in PUT request.
 */
public data class ApplicationGatewaySslCertificateArgs(
    public val `data`: Output<String>? = null,
    public val id: Output<String>? = null,
    public val keyVaultSecretId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewaySslCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewaySslCertificateArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewaySslCertificateArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .keyVaultSecretId(keyVaultSecretId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewaySslCertificateArgs].
 */
@PulumiTagMarker
public class ApplicationGatewaySslCertificateArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var id: Output<String>? = null

    private var keyVaultSecretId: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    /**
     * @param value Base-64 encoded pfx certificate. Only applicable in PUT Request.
     */
    @JvmName("efbhaefwhexjrfsc")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mppwqthexofsixkf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JvmName("uweqoewsemkjehhd")
    public suspend fun keyVaultSecretId(`value`: Output<String>) {
        this.keyVaultSecretId = value
    }

    /**
     * @param value Name of the SSL certificate that is unique within an Application Gateway.
     */
    @JvmName("bwmiyeauyepbmsuh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Password for the pfx file specified in data. Only applicable in PUT request.
     */
    @JvmName("mfyrsdfyjohhrqhi")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Base-64 encoded pfx certificate. Only applicable in PUT Request.
     */
    @JvmName("aaqmrjmbpodreisj")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mdsrxmtpvkuydniq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JvmName("dxptjqnnbhmusufa")
    public suspend fun keyVaultSecretId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretId = mapped
    }

    /**
     * @param value Name of the SSL certificate that is unique within an Application Gateway.
     */
    @JvmName("bxsycvmjkkycrvtv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Password for the pfx file specified in data. Only applicable in PUT request.
     */
    @JvmName("ihpjipomvmydhoie")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    internal fun build(): ApplicationGatewaySslCertificateArgs = ApplicationGatewaySslCertificateArgs(
        `data` = `data`,
        id = id,
        keyVaultSecretId = keyVaultSecretId,
        name = name,
        password = password,
    )
}
