@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewaySslProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSL profile of an application gateway.
 * @property clientAuthConfiguration Client authentication configuration of the application gateway resource.
 * @property id Resource ID.
 * @property name Name of the SSL profile that is unique within an Application Gateway.
 * @property sslPolicy SSL policy of the application gateway resource.
 * @property trustedClientCertificates Array of references to application gateway trusted client certificates.
 */
public data class ApplicationGatewaySslProfileArgs(
    public val clientAuthConfiguration: Output<ApplicationGatewayClientAuthConfigurationArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sslPolicy: Output<ApplicationGatewaySslPolicyArgs>? = null,
    public val trustedClientCertificates: Output<List<SubResourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewaySslProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewaySslProfileArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewaySslProfileArgs.builder()
            .clientAuthConfiguration(
                clientAuthConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sslPolicy(sslPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trustedClientCertificates(
                trustedClientCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewaySslProfileArgs].
 */
@PulumiTagMarker
public class ApplicationGatewaySslProfileArgsBuilder internal constructor() {
    private var clientAuthConfiguration: Output<ApplicationGatewayClientAuthConfigurationArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var sslPolicy: Output<ApplicationGatewaySslPolicyArgs>? = null

    private var trustedClientCertificates: Output<List<SubResourceArgs>>? = null

    /**
     * @param value Client authentication configuration of the application gateway resource.
     */
    @JvmName("qkkbmsdrtnkklqfp")
    public suspend
    fun clientAuthConfiguration(`value`: Output<ApplicationGatewayClientAuthConfigurationArgs>) {
        this.clientAuthConfiguration = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bhanvfdxatfchtie")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the SSL profile that is unique within an Application Gateway.
     */
    @JvmName("daxiiymrycvvmaqt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SSL policy of the application gateway resource.
     */
    @JvmName("pxkhgrgyokhwvqmm")
    public suspend fun sslPolicy(`value`: Output<ApplicationGatewaySslPolicyArgs>) {
        this.sslPolicy = value
    }

    /**
     * @param value Array of references to application gateway trusted client certificates.
     */
    @JvmName("twesydmyphlydkrp")
    public suspend fun trustedClientCertificates(`value`: Output<List<SubResourceArgs>>) {
        this.trustedClientCertificates = value
    }

    @JvmName("ubsuepmxrxudovmb")
    public suspend fun trustedClientCertificates(vararg values: Output<SubResourceArgs>) {
        this.trustedClientCertificates = Output.all(values.asList())
    }

    /**
     * @param values Array of references to application gateway trusted client certificates.
     */
    @JvmName("ubujkxsyehkjcupg")
    public suspend fun trustedClientCertificates(values: List<Output<SubResourceArgs>>) {
        this.trustedClientCertificates = Output.all(values)
    }

    /**
     * @param value Client authentication configuration of the application gateway resource.
     */
    @JvmName("comkgcceqhjytgxi")
    public suspend
    fun clientAuthConfiguration(`value`: ApplicationGatewayClientAuthConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthConfiguration = mapped
    }

    /**
     * @param argument Client authentication configuration of the application gateway resource.
     */
    @JvmName("kimtoiwjprrlfgiw")
    public suspend
    fun clientAuthConfiguration(argument: suspend ApplicationGatewayClientAuthConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayClientAuthConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clientAuthConfiguration = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("echlfpgyintnjpsh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the SSL profile that is unique within an Application Gateway.
     */
    @JvmName("urtfdyeqkijvdcyf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SSL policy of the application gateway resource.
     */
    @JvmName("podajcupbnqddowp")
    public suspend fun sslPolicy(`value`: ApplicationGatewaySslPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPolicy = mapped
    }

    /**
     * @param argument SSL policy of the application gateway resource.
     */
    @JvmName("mtyvnxlkrejrpldu")
    public suspend
    fun sslPolicy(argument: suspend ApplicationGatewaySslPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewaySslPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslPolicy = mapped
    }

    /**
     * @param value Array of references to application gateway trusted client certificates.
     */
    @JvmName("pyciikoqfijerwqu")
    public suspend fun trustedClientCertificates(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedClientCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted client certificates.
     */
    @JvmName("beywjjyorshhruxr")
    public suspend
    fun trustedClientCertificates(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.trustedClientCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted client certificates.
     */
    @JvmName("lajyxjpyxegadwaq")
    public suspend fun trustedClientCertificates(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.trustedClientCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted client certificates.
     */
    @JvmName("rqttarquwvoryrqy")
    public suspend
    fun trustedClientCertificates(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trustedClientCertificates = mapped
    }

    /**
     * @param values Array of references to application gateway trusted client certificates.
     */
    @JvmName("dkqkmqhsloymykmv")
    public suspend fun trustedClientCertificates(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedClientCertificates = mapped
    }

    internal fun build(): ApplicationGatewaySslProfileArgs = ApplicationGatewaySslProfileArgs(
        clientAuthConfiguration = clientAuthConfiguration,
        id = id,
        name = name,
        sslPolicy = sslPolicy,
        trustedClientCertificates = trustedClientCertificates,
    )
}
