@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule of type application.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property fqdnTags List of FQDN Tags for this rule.
 * @property httpHeadersToInsert List of HTTP/S headers to insert.
 * @property name Name of the rule.
 * @property protocols Array of Application Protocols.
 * @property ruleType Rule Type.
 * Expected value is 'ApplicationRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule.
 * @property targetUrls List of Urls for this rule condition.
 * @property terminateTLS Terminate TLS connections for this rule.
 * @property webCategories List of destination azure web categories.
 */
public data class ApplicationRuleArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val fqdnTags: Output<List<String>>? = null,
    public val httpHeadersToInsert: Output<List<FirewallPolicyHttpHeaderToInsertArgs>>? = null,
    public val name: Output<String>? = null,
    public val protocols: Output<List<FirewallPolicyRuleApplicationProtocolArgs>>? = null,
    public val ruleType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
    public val targetFqdns: Output<List<String>>? = null,
    public val targetUrls: Output<List<String>>? = null,
    public val terminateTLS: Output<Boolean>? = null,
    public val webCategories: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationRuleArgs =
        com.pulumi.azurenative.network.inputs.ApplicationRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fqdnTags(fqdnTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpHeadersToInsert(
                httpHeadersToInsert?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetFqdns(targetFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetUrls(targetUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .terminateTLS(terminateTLS?.applyValue({ args0 -> args0 }))
            .webCategories(webCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationRuleArgs].
 */
@PulumiTagMarker
public class ApplicationRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var fqdnTags: Output<List<String>>? = null

    private var httpHeadersToInsert: Output<List<FirewallPolicyHttpHeaderToInsertArgs>>? = null

    private var name: Output<String>? = null

    private var protocols: Output<List<FirewallPolicyRuleApplicationProtocolArgs>>? = null

    private var ruleType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    private var targetFqdns: Output<List<String>>? = null

    private var targetUrls: Output<List<String>>? = null

    private var terminateTLS: Output<Boolean>? = null

    private var webCategories: Output<List<String>>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("qdtjrbvfkqxgqrhv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("kiwldktkglcwbxac")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("bgokubgfgpcrknpo")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("drvlopllytkfigvn")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of FQDN Tags for this rule.
     */
    @JvmName("fbqhykfuctyojjdw")
    public suspend fun fqdnTags(`value`: Output<List<String>>) {
        this.fqdnTags = value
    }

    @JvmName("eitripchnqcjkuqn")
    public suspend fun fqdnTags(vararg values: Output<String>) {
        this.fqdnTags = Output.all(values.asList())
    }

    /**
     * @param values List of FQDN Tags for this rule.
     */
    @JvmName("qucsiqgokujckrnf")
    public suspend fun fqdnTags(values: List<Output<String>>) {
        this.fqdnTags = Output.all(values)
    }

    /**
     * @param value List of HTTP/S headers to insert.
     */
    @JvmName("uxnrpiuiygsxvgoc")
    public suspend
    fun httpHeadersToInsert(`value`: Output<List<FirewallPolicyHttpHeaderToInsertArgs>>) {
        this.httpHeadersToInsert = value
    }

    @JvmName("lmblvwfabuonqoxu")
    public suspend fun httpHeadersToInsert(
        vararg
        values: Output<FirewallPolicyHttpHeaderToInsertArgs>,
    ) {
        this.httpHeadersToInsert = Output.all(values.asList())
    }

    /**
     * @param values List of HTTP/S headers to insert.
     */
    @JvmName("vobgrgeytjbkflrk")
    public suspend
    fun httpHeadersToInsert(values: List<Output<FirewallPolicyHttpHeaderToInsertArgs>>) {
        this.httpHeadersToInsert = Output.all(values)
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("ctykivjgwfcthhue")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of Application Protocols.
     */
    @JvmName("jyxvwirwlqegellr")
    public suspend fun protocols(`value`: Output<List<FirewallPolicyRuleApplicationProtocolArgs>>) {
        this.protocols = value
    }

    @JvmName("sliteqmundlqrlgc")
    public suspend fun protocols(vararg values: Output<FirewallPolicyRuleApplicationProtocolArgs>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Array of Application Protocols.
     */
    @JvmName("exjexrlgqopmesga")
    public suspend fun protocols(values: List<Output<FirewallPolicyRuleApplicationProtocolArgs>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value Rule Type.
     * Expected value is 'ApplicationRule'.
     */
    @JvmName("jkdjtibgqypubcay")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("oicwjpwqouoryach")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("nlkgftgpueuedtbm")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("qbtuwtasmgacmnuh")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("heuubscaaejmveve")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("qhljrusibpsfcewd")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("samvpfkfsasqrtfi")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value List of FQDNs for this rule.
     */
    @JvmName("jyqnlinwbklmmyyy")
    public suspend fun targetFqdns(`value`: Output<List<String>>) {
        this.targetFqdns = value
    }

    @JvmName("axscrgyfpclusjyc")
    public suspend fun targetFqdns(vararg values: Output<String>) {
        this.targetFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of FQDNs for this rule.
     */
    @JvmName("xxtkcsdlqnkrvqlq")
    public suspend fun targetFqdns(values: List<Output<String>>) {
        this.targetFqdns = Output.all(values)
    }

    /**
     * @param value List of Urls for this rule condition.
     */
    @JvmName("sxobmrseofxvuhlk")
    public suspend fun targetUrls(`value`: Output<List<String>>) {
        this.targetUrls = value
    }

    @JvmName("pfdbbdyjyweqdhes")
    public suspend fun targetUrls(vararg values: Output<String>) {
        this.targetUrls = Output.all(values.asList())
    }

    /**
     * @param values List of Urls for this rule condition.
     */
    @JvmName("xaanwcsrdvuvamwi")
    public suspend fun targetUrls(values: List<Output<String>>) {
        this.targetUrls = Output.all(values)
    }

    /**
     * @param value Terminate TLS connections for this rule.
     */
    @JvmName("vpyolbkednvrjceh")
    public suspend fun terminateTLS(`value`: Output<Boolean>) {
        this.terminateTLS = value
    }

    /**
     * @param value List of destination azure web categories.
     */
    @JvmName("stxoqioojutjlgcx")
    public suspend fun webCategories(`value`: Output<List<String>>) {
        this.webCategories = value
    }

    @JvmName("cbbmwacqoiuxwbng")
    public suspend fun webCategories(vararg values: Output<String>) {
        this.webCategories = Output.all(values.asList())
    }

    /**
     * @param values List of destination azure web categories.
     */
    @JvmName("jarngxvlerpqkcix")
    public suspend fun webCategories(values: List<Output<String>>) {
        this.webCategories = Output.all(values)
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("xxeljdlyublnjdhi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("jnbtbcebuldcwcdv")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("xyajqiocakiugjme")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of FQDN Tags for this rule.
     */
    @JvmName("ixmohyabnnputjts")
    public suspend fun fqdnTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param values List of FQDN Tags for this rule.
     */
    @JvmName("rxdqcqjuuxgnkxqc")
    public suspend fun fqdnTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param value List of HTTP/S headers to insert.
     */
    @JvmName("qdvkbhurfolhjddv")
    public suspend fun httpHeadersToInsert(`value`: List<FirewallPolicyHttpHeaderToInsertArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param argument List of HTTP/S headers to insert.
     */
    @JvmName("bolilprjgbrbglxt")
    public suspend
    fun httpHeadersToInsert(argument: List<suspend FirewallPolicyHttpHeaderToInsertArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyHttpHeaderToInsertArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param argument List of HTTP/S headers to insert.
     */
    @JvmName("tjqjlbgeyptirdke")
    public suspend fun httpHeadersToInsert(
        vararg
        argument: suspend FirewallPolicyHttpHeaderToInsertArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyHttpHeaderToInsertArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param argument List of HTTP/S headers to insert.
     */
    @JvmName("tmlccppqmptxffda")
    public suspend
    fun httpHeadersToInsert(argument: suspend FirewallPolicyHttpHeaderToInsertArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallPolicyHttpHeaderToInsertArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param values List of HTTP/S headers to insert.
     */
    @JvmName("krowxeceufjerarr")
    public suspend fun httpHeadersToInsert(vararg values: FirewallPolicyHttpHeaderToInsertArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeadersToInsert = mapped
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("vgogkrtrqtetofld")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of Application Protocols.
     */
    @JvmName("gdtqooytyaqspuja")
    public suspend fun protocols(`value`: List<FirewallPolicyRuleApplicationProtocolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("ogdgleqyjyhtvhlt")
    public suspend
    fun protocols(argument: List<suspend FirewallPolicyRuleApplicationProtocolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyRuleApplicationProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("cygqhnbpxgyxsoxo")
    public suspend fun protocols(
        vararg
        argument: suspend FirewallPolicyRuleApplicationProtocolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyRuleApplicationProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("ovpyleulvtkdpkex")
    public suspend
    fun protocols(argument: suspend FirewallPolicyRuleApplicationProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallPolicyRuleApplicationProtocolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param values Array of Application Protocols.
     */
    @JvmName("bqaerruiwtdsvokg")
    public suspend fun protocols(vararg values: FirewallPolicyRuleApplicationProtocolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value Rule Type.
     * Expected value is 'ApplicationRule'.
     */
    @JvmName("hnjirsysvkosrxhi")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("ecbhpqbxfjedqtix")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("bgyyiukfkkevteoe")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("nqemqulurdydlwet")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("fnkcyngasktsbcpq")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param value List of FQDNs for this rule.
     */
    @JvmName("ufyehnfeoqmimult")
    public suspend fun targetFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    /**
     * @param values List of FQDNs for this rule.
     */
    @JvmName("wlsegrydsgygwdgn")
    public suspend fun targetFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    /**
     * @param value List of Urls for this rule condition.
     */
    @JvmName("ugvluygyjkikrjws")
    public suspend fun targetUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUrls = mapped
    }

    /**
     * @param values List of Urls for this rule condition.
     */
    @JvmName("msaqfwdemrinksfy")
    public suspend fun targetUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrls = mapped
    }

    /**
     * @param value Terminate TLS connections for this rule.
     */
    @JvmName("umnyscuckdshruqy")
    public suspend fun terminateTLS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateTLS = mapped
    }

    /**
     * @param value List of destination azure web categories.
     */
    @JvmName("gofypgewvtrkdhpb")
    public suspend fun webCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webCategories = mapped
    }

    /**
     * @param values List of destination azure web categories.
     */
    @JvmName("galjmtvnlampwnbp")
    public suspend fun webCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webCategories = mapped
    }

    internal fun build(): ApplicationRuleArgs = ApplicationRuleArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        fqdnTags = fqdnTags,
        httpHeadersToInsert = httpHeadersToInsert,
        name = name,
        protocols = protocols,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
        targetFqdns = targetFqdns,
        targetUrls = targetUrls,
        terminateTLS = terminateTLS,
        webCategories = webCategories,
    )
}
