@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule condition of type application.
 * @property description Description of the rule condition.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property fqdnTags List of FQDN Tags for this rule condition.
 * @property name Name of the rule condition.
 * @property protocols Array of Application Protocols.
 * @property ruleConditionType Rule Condition Type.
 * Expected value is 'ApplicationRuleCondition'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule condition.
 */
public data class ApplicationRuleConditionArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val fqdnTags: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val protocols: Output<List<FirewallPolicyRuleConditionApplicationProtocolArgs>>? = null,
    public val ruleConditionType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
    public val targetFqdns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationRuleConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationRuleConditionArgs =
        com.pulumi.azurenative.network.inputs.ApplicationRuleConditionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fqdnTags(fqdnTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleConditionType(ruleConditionType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetFqdns(targetFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationRuleConditionArgs].
 */
@PulumiTagMarker
public class ApplicationRuleConditionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var fqdnTags: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var protocols: Output<List<FirewallPolicyRuleConditionApplicationProtocolArgs>>? = null

    private var ruleConditionType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    private var targetFqdns: Output<List<String>>? = null

    /**
     * @param value Description of the rule condition.
     */
    @JvmName("ifloljvcibuptjhi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("mcuddxgwryyouayb")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("vnckemdtcppmpbji")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("xrsvpiypgeubhafh")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of FQDN Tags for this rule condition.
     */
    @JvmName("pijgiabbfnkwoamb")
    public suspend fun fqdnTags(`value`: Output<List<String>>) {
        this.fqdnTags = value
    }

    @JvmName("lmkwdvsnuvligkbj")
    public suspend fun fqdnTags(vararg values: Output<String>) {
        this.fqdnTags = Output.all(values.asList())
    }

    /**
     * @param values List of FQDN Tags for this rule condition.
     */
    @JvmName("wwvxmrhiatmnnmmr")
    public suspend fun fqdnTags(values: List<Output<String>>) {
        this.fqdnTags = Output.all(values)
    }

    /**
     * @param value Name of the rule condition.
     */
    @JvmName("wjiulxijilwnuwln")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of Application Protocols.
     */
    @JvmName("xjmqsdwkjesfcyub")
    public suspend
    fun protocols(`value`: Output<List<FirewallPolicyRuleConditionApplicationProtocolArgs>>) {
        this.protocols = value
    }

    @JvmName("dbtydccaapvbkwro")
    public suspend fun protocols(
        vararg
        values: Output<FirewallPolicyRuleConditionApplicationProtocolArgs>,
    ) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Array of Application Protocols.
     */
    @JvmName("pmeuuteysigqqqyt")
    public suspend
    fun protocols(values: List<Output<FirewallPolicyRuleConditionApplicationProtocolArgs>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value Rule Condition Type.
     * Expected value is 'ApplicationRuleCondition'.
     */
    @JvmName("olygtmhpnjdykjbr")
    public suspend fun ruleConditionType(`value`: Output<String>) {
        this.ruleConditionType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("xvrtxlxhxuxcuube")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("ndetxkhpfjbivvuj")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("waamdfrwwnsjqkvq")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("yrdmsmfxknmtsrlj")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("ephpugaujrltrqld")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("uwhfwryoeiukqwbu")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value List of FQDNs for this rule condition.
     */
    @JvmName("jhvjhvnmwanwmprc")
    public suspend fun targetFqdns(`value`: Output<List<String>>) {
        this.targetFqdns = value
    }

    @JvmName("dsfmkftrdvppvebj")
    public suspend fun targetFqdns(vararg values: Output<String>) {
        this.targetFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of FQDNs for this rule condition.
     */
    @JvmName("aaniietrurcrpbdf")
    public suspend fun targetFqdns(values: List<Output<String>>) {
        this.targetFqdns = Output.all(values)
    }

    /**
     * @param value Description of the rule condition.
     */
    @JvmName("hxbbxklxqwrovnhg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("snkdalqtvkitfyjn")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("boiyxblditidesrj")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of FQDN Tags for this rule condition.
     */
    @JvmName("vyiangnkdaspwvpw")
    public suspend fun fqdnTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param values List of FQDN Tags for this rule condition.
     */
    @JvmName("mhxkjtvgqixfebwp")
    public suspend fun fqdnTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param value Name of the rule condition.
     */
    @JvmName("ngvxkojwutmadghh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of Application Protocols.
     */
    @JvmName("sqqgoqqybqbgawec")
    public suspend fun protocols(`value`: List<FirewallPolicyRuleConditionApplicationProtocolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("mikwkhxaoulgglvd")
    public suspend
    fun protocols(argument: List<suspend FirewallPolicyRuleConditionApplicationProtocolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyRuleConditionApplicationProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("uvqcyqnlojlseusl")
    public suspend fun protocols(
        vararg
        argument: suspend FirewallPolicyRuleConditionApplicationProtocolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyRuleConditionApplicationProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of Application Protocols.
     */
    @JvmName("vvyoyyryqfdesrqu")
    public suspend
    fun protocols(argument: suspend FirewallPolicyRuleConditionApplicationProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallPolicyRuleConditionApplicationProtocolArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param values Array of Application Protocols.
     */
    @JvmName("hviuyabhapkikhsi")
    public suspend fun protocols(vararg values: FirewallPolicyRuleConditionApplicationProtocolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value Rule Condition Type.
     * Expected value is 'ApplicationRuleCondition'.
     */
    @JvmName("aicwypibcrrdhewg")
    public suspend fun ruleConditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleConditionType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("hxvexodoyttcsbye")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("bghbaqcgkrwevhpy")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("gnuopdkobtuwlccl")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("yarnhowjmstcatdd")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param value List of FQDNs for this rule condition.
     */
    @JvmName("omrnxjdgevvudtlh")
    public suspend fun targetFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    /**
     * @param values List of FQDNs for this rule condition.
     */
    @JvmName("jjoqcrufxhqlhprd")
    public suspend fun targetFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    internal fun build(): ApplicationRuleConditionArgs = ApplicationRuleConditionArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        fqdnTags = fqdnTags,
        name = name,
        protocols = protocols,
        ruleConditionType = ruleConditionType ?: throw PulumiNullFieldException("ruleConditionType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
        targetFqdns = targetFqdns,
    )
}
