@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallIPConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP configuration of an Azure Firewall.
 * @property id Resource ID.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property publicIPAddress Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
 * @property subnet Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
 */
public data class AzureFirewallIPConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publicIPAddress: Output<SubResourceArgs>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallIPConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AzureFirewallIPConfigurationArgs].
 */
@PulumiTagMarker
public class AzureFirewallIPConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var publicIPAddress: Output<SubResourceArgs>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("toljohvnpajixnro")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("uatgsphjbrmlqbfr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
     */
    @JvmName("dgadpucwnwqafpfx")
    public suspend fun publicIPAddress(`value`: Output<SubResourceArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
     */
    @JvmName("qktolvqxstcwifol")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pbjykgoelqlxuxdy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("scetiepgjnedwvbs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
     */
    @JvmName("pduwrxbixyqhsvvl")
    public suspend fun publicIPAddress(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
     */
    @JvmName("xsuhhxydikwiuikk")
    public suspend fun publicIPAddress(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
     */
    @JvmName("wspvvggvlqhwmsdh")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
     */
    @JvmName("mgwshdglhniiisdc")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): AzureFirewallIPConfigurationArgs = AzureFirewallIPConfigurationArgs(
        id = id,
        name = name,
        publicIPAddress = publicIPAddress,
        subnet = subnet,
    )
}
