@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallNatRCActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallNatRCActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AzureFirewall NAT Rule Collection Action.
 * @property type The type of action.
 */
public data class AzureFirewallNatRCActionArgs(
    public val type: Output<Either<String, AzureFirewallNatRCActionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallNatRCActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallNatRCActionArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallNatRCActionArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallNatRCActionArgs].
 */
@PulumiTagMarker
public class AzureFirewallNatRCActionArgsBuilder internal constructor() {
    private var type: Output<Either<String, AzureFirewallNatRCActionType>>? = null

    /**
     * @param value The type of action.
     */
    @JvmName("lcuicjxonjxmgudp")
    public suspend fun type(`value`: Output<Either<String, AzureFirewallNatRCActionType>>) {
        this.type = value
    }

    /**
     * @param value The type of action.
     */
    @JvmName("jbqjgkexytxvmlib")
    public suspend fun type(`value`: Either<String, AzureFirewallNatRCActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("cwksmfijjsumqoae")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallNatRCActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("jrgpgdtcqxdmsnff")
    public fun type(`value`: AzureFirewallNatRCActionType) {
        val toBeMapped = Either.ofRight<String, AzureFirewallNatRCActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFirewallNatRCActionArgs = AzureFirewallNatRCActionArgs(
        type = type,
    )
}
