@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallPublicIPAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Public IP Address associated with azure firewall.
 * @property address Public IP Address value.
 */
public data class AzureFirewallPublicIPAddressArgs(
    public val address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallPublicIPAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallPublicIPAddressArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallPublicIPAddressArgs.builder()
            .address(address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFirewallPublicIPAddressArgs].
 */
@PulumiTagMarker
public class AzureFirewallPublicIPAddressArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    /**
     * @param value Public IP Address value.
     */
    @JvmName("hnefhyfbkixkdkwg")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value Public IP Address value.
     */
    @JvmName("aevjdracnkfigblx")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    internal fun build(): AzureFirewallPublicIPAddressArgs = AzureFirewallPublicIPAddressArgs(
        address = address,
    )
}
