@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallSkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallSkuName
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of an Azure Firewall.
 * @property name Name of an Azure Firewall SKU.
 * @property tier Tier of an Azure Firewall.
 */
public data class AzureFirewallSkuArgs(
    public val name: Output<Either<String, AzureFirewallSkuName>>? = null,
    public val tier: Output<Either<String, AzureFirewallSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallSkuArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallSkuArgs].
 */
@PulumiTagMarker
public class AzureFirewallSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, AzureFirewallSkuName>>? = null

    private var tier: Output<Either<String, AzureFirewallSkuTier>>? = null

    /**
     * @param value Name of an Azure Firewall SKU.
     */
    @JvmName("phfvojdtsvbdxugw")
    public suspend fun name(`value`: Output<Either<String, AzureFirewallSkuName>>) {
        this.name = value
    }

    /**
     * @param value Tier of an Azure Firewall.
     */
    @JvmName("gcrqaampctpqoxca")
    public suspend fun tier(`value`: Output<Either<String, AzureFirewallSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Name of an Azure Firewall SKU.
     */
    @JvmName("reevhxpuntrmrvnu")
    public suspend fun name(`value`: Either<String, AzureFirewallSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Firewall SKU.
     */
    @JvmName("yuqsifypkpkrjvyl")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Firewall SKU.
     */
    @JvmName("termnwvffbswdqcm")
    public fun name(`value`: AzureFirewallSkuName) {
        val toBeMapped = Either.ofRight<String, AzureFirewallSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of an Azure Firewall.
     */
    @JvmName("udmovsgcnmqxqcty")
    public suspend fun tier(`value`: Either<String, AzureFirewallSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of an Azure Firewall.
     */
    @JvmName("fbtpxifvimbcroep")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of an Azure Firewall.
     */
    @JvmName("wmgerdvrhbncdxul")
    public fun tier(`value`: AzureFirewallSkuTier) {
        val toBeMapped = Either.ofRight<String, AzureFirewallSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): AzureFirewallSkuArgs = AzureFirewallSkuArgs(
        name = name,
        tier = tier,
    )
}
