@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Pool of backend IP addresses.
 * @property drainPeriodInSeconds Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
 * @property id Resource ID.
 * @property loadBalancerBackendAddresses An array of backend addresses.
 * @property location The location of the backend address pool.
 * @property name The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
 * @property tunnelInterfaces An array of gateway load balancer tunnel interfaces.
 * @property virtualNetwork A reference to a virtual network.
 */
public data class BackendAddressPoolArgs(
    public val drainPeriodInSeconds: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val loadBalancerBackendAddresses: Output<List<LoadBalancerBackendAddressArgs>>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tunnelInterfaces: Output<List<GatewayLoadBalancerTunnelInterfaceArgs>>? = null,
    public val virtualNetwork: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs =
        com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs.builder()
            .drainPeriodInSeconds(drainPeriodInSeconds?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .loadBalancerBackendAddresses(
                loadBalancerBackendAddresses?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tunnelInterfaces(
                tunnelInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetwork(
                virtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BackendAddressPoolArgs].
 */
@PulumiTagMarker
public class BackendAddressPoolArgsBuilder internal constructor() {
    private var drainPeriodInSeconds: Output<Int>? = null

    private var id: Output<String>? = null

    private var loadBalancerBackendAddresses: Output<List<LoadBalancerBackendAddressArgs>>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var tunnelInterfaces: Output<List<GatewayLoadBalancerTunnelInterfaceArgs>>? = null

    private var virtualNetwork: Output<SubResourceArgs>? = null

    /**
     * @param value Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
     */
    @JvmName("lirwvyjifnyirpog")
    public suspend fun drainPeriodInSeconds(`value`: Output<Int>) {
        this.drainPeriodInSeconds = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wcinoqqjrohfhggt")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value An array of backend addresses.
     */
    @JvmName("okkcnsvvguuojgde")
    public suspend
    fun loadBalancerBackendAddresses(`value`: Output<List<LoadBalancerBackendAddressArgs>>) {
        this.loadBalancerBackendAddresses = value
    }

    @JvmName("sbuujbpwmfnjxhce")
    public suspend fun loadBalancerBackendAddresses(
        vararg
        values: Output<LoadBalancerBackendAddressArgs>,
    ) {
        this.loadBalancerBackendAddresses = Output.all(values.asList())
    }

    /**
     * @param values An array of backend addresses.
     */
    @JvmName("ntgbqbfhtxcfaoed")
    public suspend
    fun loadBalancerBackendAddresses(values: List<Output<LoadBalancerBackendAddressArgs>>) {
        this.loadBalancerBackendAddresses = Output.all(values)
    }

    /**
     * @param value The location of the backend address pool.
     */
    @JvmName("ymjfypltjocldksl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("qvbajglbygghtwtx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("iqejweoeijtcoklu")
    public suspend
    fun tunnelInterfaces(`value`: Output<List<GatewayLoadBalancerTunnelInterfaceArgs>>) {
        this.tunnelInterfaces = value
    }

    @JvmName("umqwvniqwfdgxxyb")
    public suspend fun tunnelInterfaces(
        vararg
        values: Output<GatewayLoadBalancerTunnelInterfaceArgs>,
    ) {
        this.tunnelInterfaces = Output.all(values.asList())
    }

    /**
     * @param values An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("rwjhpwcxrpumcdki")
    public suspend
    fun tunnelInterfaces(values: List<Output<GatewayLoadBalancerTunnelInterfaceArgs>>) {
        this.tunnelInterfaces = Output.all(values)
    }

    /**
     * @param value A reference to a virtual network.
     */
    @JvmName("mhhjyxmeiakhxovo")
    public suspend fun virtualNetwork(`value`: Output<SubResourceArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
     */
    @JvmName("rxqlopmsmptgmeoe")
    public suspend fun drainPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drainPeriodInSeconds = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bgwhbstbvjsdxwbi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value An array of backend addresses.
     */
    @JvmName("oyvfikuyjgbkdqjn")
    public suspend fun loadBalancerBackendAddresses(`value`: List<LoadBalancerBackendAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param argument An array of backend addresses.
     */
    @JvmName("lpdsaxsaffrpxbhg")
    public suspend
    fun loadBalancerBackendAddresses(argument: List<suspend LoadBalancerBackendAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerBackendAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param argument An array of backend addresses.
     */
    @JvmName("nkqubyaasglawcpw")
    public suspend fun loadBalancerBackendAddresses(
        vararg
        argument: suspend LoadBalancerBackendAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerBackendAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param argument An array of backend addresses.
     */
    @JvmName("vxvhlowobhwgeaur")
    public suspend
    fun loadBalancerBackendAddresses(argument: suspend LoadBalancerBackendAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerBackendAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param values An array of backend addresses.
     */
    @JvmName("hnkwpjlpavkvwmdw")
    public suspend fun loadBalancerBackendAddresses(vararg values: LoadBalancerBackendAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddresses = mapped
    }

    /**
     * @param value The location of the backend address pool.
     */
    @JvmName("xviyiwvngydxprgi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("brlcarwovjviborw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("uopxnhtgbiavekmb")
    public suspend fun tunnelInterfaces(`value`: List<GatewayLoadBalancerTunnelInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelInterfaces = mapped
    }

    /**
     * @param argument An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("fsiyrqqewmubyqod")
    public suspend
    fun tunnelInterfaces(argument: List<suspend GatewayLoadBalancerTunnelInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayLoadBalancerTunnelInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tunnelInterfaces = mapped
    }

    /**
     * @param argument An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("dhsalwwvtabyvypk")
    public suspend fun tunnelInterfaces(
        vararg
        argument: suspend GatewayLoadBalancerTunnelInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GatewayLoadBalancerTunnelInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tunnelInterfaces = mapped
    }

    /**
     * @param argument An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("piwhrghgwdamhhlq")
    public suspend
    fun tunnelInterfaces(argument: suspend GatewayLoadBalancerTunnelInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayLoadBalancerTunnelInterfaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tunnelInterfaces = mapped
    }

    /**
     * @param values An array of gateway load balancer tunnel interfaces.
     */
    @JvmName("bnxtigqiefvwvatw")
    public suspend fun tunnelInterfaces(vararg values: GatewayLoadBalancerTunnelInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tunnelInterfaces = mapped
    }

    /**
     * @param value A reference to a virtual network.
     */
    @JvmName("naxqkvugibvfroro")
    public suspend fun virtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument A reference to a virtual network.
     */
    @JvmName("mhmxgprmhrromxim")
    public suspend fun virtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    internal fun build(): BackendAddressPoolArgs = BackendAddressPoolArgs(
        drainPeriodInSeconds = drainPeriodInSeconds,
        id = id,
        loadBalancerBackendAddresses = loadBalancerBackendAddresses,
        location = location,
        name = name,
        tunnelInterfaces = tunnelInterfaces,
        virtualNetwork = virtualNetwork,
    )
}
