@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BackendPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A backend pool is a collection of backends that can be routed to.
 * @property backends The set of backends for this pool
 * @property healthProbeSettings L7 health probe settings for a backend pool
 * @property id Resource ID.
 * @property loadBalancingSettings Load balancing settings for a backend pool
 * @property name Resource name.
 */
public data class BackendPoolArgs(
    public val backends: Output<List<BackendArgs>>? = null,
    public val healthProbeSettings: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val loadBalancingSettings: Output<SubResourceArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BackendPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BackendPoolArgs =
        com.pulumi.azurenative.network.inputs.BackendPoolArgs.builder()
            .backends(
                backends?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .healthProbeSettings(
                healthProbeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .loadBalancingSettings(
                loadBalancingSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendPoolArgs].
 */
@PulumiTagMarker
public class BackendPoolArgsBuilder internal constructor() {
    private var backends: Output<List<BackendArgs>>? = null

    private var healthProbeSettings: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var loadBalancingSettings: Output<SubResourceArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The set of backends for this pool
     */
    @JvmName("snoeruvtibadrrtp")
    public suspend fun backends(`value`: Output<List<BackendArgs>>) {
        this.backends = value
    }

    @JvmName("fmrqkokqipohvsmw")
    public suspend fun backends(vararg values: Output<BackendArgs>) {
        this.backends = Output.all(values.asList())
    }

    /**
     * @param values The set of backends for this pool
     */
    @JvmName("npywxnkfaxhwnmgk")
    public suspend fun backends(values: List<Output<BackendArgs>>) {
        this.backends = Output.all(values)
    }

    /**
     * @param value L7 health probe settings for a backend pool
     */
    @JvmName("wnonopquflcpfcpo")
    public suspend fun healthProbeSettings(`value`: Output<SubResourceArgs>) {
        this.healthProbeSettings = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xssncrtjhdxshwev")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Load balancing settings for a backend pool
     */
    @JvmName("qnndeeafatcvfmvo")
    public suspend fun loadBalancingSettings(`value`: Output<SubResourceArgs>) {
        this.loadBalancingSettings = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("turupfgaqgntocih")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The set of backends for this pool
     */
    @JvmName("cwexnfkcaptkamuf")
    public suspend fun backends(`value`: List<BackendArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backends = mapped
    }

    /**
     * @param argument The set of backends for this pool
     */
    @JvmName("ogouturcxsynbkck")
    public suspend fun backends(argument: List<suspend BackendArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BackendArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backends = mapped
    }

    /**
     * @param argument The set of backends for this pool
     */
    @JvmName("pqtwyrujekoihepg")
    public suspend fun backends(vararg argument: suspend BackendArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BackendArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backends = mapped
    }

    /**
     * @param argument The set of backends for this pool
     */
    @JvmName("smdiglntsyrwcmrb")
    public suspend fun backends(argument: suspend BackendArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BackendArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backends = mapped
    }

    /**
     * @param values The set of backends for this pool
     */
    @JvmName("uaeansxencrclbsp")
    public suspend fun backends(vararg values: BackendArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backends = mapped
    }

    /**
     * @param value L7 health probe settings for a backend pool
     */
    @JvmName("dtbkidehqsibtnjj")
    public suspend fun healthProbeSettings(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument L7 health probe settings for a backend pool
     */
    @JvmName("mfpnabjpuadhameb")
    public suspend fun healthProbeSettings(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pgxfbacuolnclbco")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Load balancing settings for a backend pool
     */
    @JvmName("cvohnekimqiyjepi")
    public suspend fun loadBalancingSettings(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings for a backend pool
     */
    @JvmName("scsyjtxqmxmfsegl")
    public suspend fun loadBalancingSettings(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("tsbnvmldwdamfmwl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BackendPoolArgs = BackendPoolArgs(
        backends = backends,
        healthProbeSettings = healthProbeSettings,
        id = id,
        loadBalancingSettings = loadBalancingSettings,
        name = name,
    )
}
