@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorTcpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DestinationPortBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the TCP configuration.
 * @property destinationPortBehavior Destination port behavior.
 * @property disableTraceRoute Value indicating whether path evaluation with trace route should be disabled.
 * @property port The port to connect to.
 */
public data class ConnectionMonitorTcpConfigurationArgs(
    public val destinationPortBehavior: Output<Either<String, DestinationPortBehavior>>? = null,
    public val disableTraceRoute: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorTcpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorTcpConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorTcpConfigurationArgs.builder()
            .destinationPortBehavior(
                destinationPortBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .disableTraceRoute(disableTraceRoute?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorTcpConfigurationArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorTcpConfigurationArgsBuilder internal constructor() {
    private var destinationPortBehavior: Output<Either<String, DestinationPortBehavior>>? = null

    private var disableTraceRoute: Output<Boolean>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Destination port behavior.
     */
    @JvmName("tsopxxhabpdfwcjq")
    public suspend
    fun destinationPortBehavior(`value`: Output<Either<String, DestinationPortBehavior>>) {
        this.destinationPortBehavior = value
    }

    /**
     * @param value Value indicating whether path evaluation with trace route should be disabled.
     */
    @JvmName("wpuhiiutlisretap")
    public suspend fun disableTraceRoute(`value`: Output<Boolean>) {
        this.disableTraceRoute = value
    }

    /**
     * @param value The port to connect to.
     */
    @JvmName("iawsvacnolcfmmdq")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Destination port behavior.
     */
    @JvmName("dhdeqlfmyghciycy")
    public suspend fun destinationPortBehavior(`value`: Either<String, DestinationPortBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortBehavior = mapped
    }

    /**
     * @param value Destination port behavior.
     */
    @JvmName("yptvwbdldxqqakco")
    public fun destinationPortBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DestinationPortBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortBehavior = mapped
    }

    /**
     * @param value Destination port behavior.
     */
    @JvmName("crmbewbwbfasdavi")
    public fun destinationPortBehavior(`value`: DestinationPortBehavior) {
        val toBeMapped = Either.ofRight<String, DestinationPortBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortBehavior = mapped
    }

    /**
     * @param value Value indicating whether path evaluation with trace route should be disabled.
     */
    @JvmName("bpiiwawoudgmemyf")
    public suspend fun disableTraceRoute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTraceRoute = mapped
    }

    /**
     * @param value The port to connect to.
     */
    @JvmName("kenmjftfnfnmkber")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ConnectionMonitorTcpConfigurationArgs =
        ConnectionMonitorTcpConfigurationArgs(
            destinationPortBehavior = destinationPortBehavior,
            disableTraceRoute = disableTraceRoute,
            port = port,
        )
}
