@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorTestGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the connection monitor test group.
 * @property destinations List of destination endpoint names.
 * @property disable Value indicating whether test group is disabled.
 * @property name The name of the connection monitor test group.
 * @property sources List of source endpoint names.
 * @property testConfigurations List of test configuration names.
 */
public data class ConnectionMonitorTestGroupArgs(
    public val destinations: Output<List<String>>,
    public val disable: Output<Boolean>? = null,
    public val name: Output<String>,
    public val sources: Output<List<String>>,
    public val testConfigurations: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorTestGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorTestGroupArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorTestGroupArgs.builder()
            .destinations(destinations.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .disable(disable?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .sources(sources.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .testConfigurations(testConfigurations.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConnectionMonitorTestGroupArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorTestGroupArgsBuilder internal constructor() {
    private var destinations: Output<List<String>>? = null

    private var disable: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var sources: Output<List<String>>? = null

    private var testConfigurations: Output<List<String>>? = null

    /**
     * @param value List of destination endpoint names.
     */
    @JvmName("afsgemoqhjaqyvrx")
    public suspend fun destinations(`value`: Output<List<String>>) {
        this.destinations = value
    }

    @JvmName("ealniliqjhebwoxr")
    public suspend fun destinations(vararg values: Output<String>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of destination endpoint names.
     */
    @JvmName("mgkkqigmfhxfupdb")
    public suspend fun destinations(values: List<Output<String>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Value indicating whether test group is disabled.
     */
    @JvmName("enggyqamnvhadbod")
    public suspend fun disable(`value`: Output<Boolean>) {
        this.disable = value
    }

    /**
     * @param value The name of the connection monitor test group.
     */
    @JvmName("lkxjsnqybdqpyyom")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of source endpoint names.
     */
    @JvmName("orgmubilbeqgkcbe")
    public suspend fun sources(`value`: Output<List<String>>) {
        this.sources = value
    }

    @JvmName("rhugagxngdhcoleo")
    public suspend fun sources(vararg values: Output<String>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values List of source endpoint names.
     */
    @JvmName("maalimwxibewqviq")
    public suspend fun sources(values: List<Output<String>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value List of test configuration names.
     */
    @JvmName("qqbuetsjdaoprmci")
    public suspend fun testConfigurations(`value`: Output<List<String>>) {
        this.testConfigurations = value
    }

    @JvmName("lxkyftekcitedack")
    public suspend fun testConfigurations(vararg values: Output<String>) {
        this.testConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of test configuration names.
     */
    @JvmName("lygnfgixdaashcjm")
    public suspend fun testConfigurations(values: List<Output<String>>) {
        this.testConfigurations = Output.all(values)
    }

    /**
     * @param value List of destination endpoint names.
     */
    @JvmName("ooabpbynlrevxnag")
    public suspend fun destinations(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param values List of destination endpoint names.
     */
    @JvmName("droajgnflopcvtwg")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Value indicating whether test group is disabled.
     */
    @JvmName("wjraknpfyroowaom")
    public suspend fun disable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disable = mapped
    }

    /**
     * @param value The name of the connection monitor test group.
     */
    @JvmName("eesepaxbsaactxxr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of source endpoint names.
     */
    @JvmName("ysgynfjrmsdkruwv")
    public suspend fun sources(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param values List of source endpoint names.
     */
    @JvmName("nougiwxiljnaibtf")
    public suspend fun sources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value List of test configuration names.
     */
    @JvmName("sgtxxjvqgfitgmci")
    public suspend fun testConfigurations(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testConfigurations = mapped
    }

    /**
     * @param values List of test configuration names.
     */
    @JvmName("wewpfdtfnnquocyd")
    public suspend fun testConfigurations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testConfigurations = mapped
    }

    internal fun build(): ConnectionMonitorTestGroupArgs = ConnectionMonitorTestGroupArgs(
        destinations = destinations ?: throw PulumiNullFieldException("destinations"),
        disable = disable,
        name = name ?: throw PulumiNullFieldException("name"),
        sources = sources ?: throw PulumiNullFieldException("sources"),
        testConfigurations = testConfigurations ?: throw PulumiNullFieldException("testConfigurations"),
    )
}
