@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CustomDnsConfigPropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contains custom Dns resolution configuration from customer.
 * @property fqdn Fqdn that resolves to private endpoint ip address.
 * @property ipAddresses A list of private ip addresses of the private endpoint.
 */
public data class CustomDnsConfigPropertiesFormatArgs(
    public val fqdn: Output<String>? = null,
    public val ipAddresses: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CustomDnsConfigPropertiesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CustomDnsConfigPropertiesFormatArgs =
        com.pulumi.azurenative.network.inputs.CustomDnsConfigPropertiesFormatArgs.builder()
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CustomDnsConfigPropertiesFormatArgs].
 */
@PulumiTagMarker
public class CustomDnsConfigPropertiesFormatArgsBuilder internal constructor() {
    private var fqdn: Output<String>? = null

    private var ipAddresses: Output<List<String>>? = null

    /**
     * @param value Fqdn that resolves to private endpoint ip address.
     */
    @JvmName("rbpbrefqqyxlayfk")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value A list of private ip addresses of the private endpoint.
     */
    @JvmName("lxtstblhnfhlouig")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("ldswglxdvvnskgat")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values A list of private ip addresses of the private endpoint.
     */
    @JvmName("aoxigevsgtwvxlen")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value Fqdn that resolves to private endpoint ip address.
     */
    @JvmName("knqsoufgovxwgueq")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value A list of private ip addresses of the private endpoint.
     */
    @JvmName("dylwyskgulscwbaf")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values A list of private ip addresses of the private endpoint.
     */
    @JvmName("hviuurhnsgyrnvij")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    internal fun build(): CustomDnsConfigPropertiesFormatArgs = CustomDnsConfigPropertiesFormatArgs(
        fqdn = fqdn,
        ipAddresses = ipAddresses,
    )
}
