@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.DevicePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * List of properties of the device.
 * @property deviceModel Model of the device.
 * @property deviceVendor Name of the device Vendor.
 * @property linkSpeedInMbps Link speed.
 */
public data class DevicePropertiesArgs(
    public val deviceModel: Output<String>? = null,
    public val deviceVendor: Output<String>? = null,
    public val linkSpeedInMbps: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.DevicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.DevicePropertiesArgs =
        com.pulumi.azurenative.network.inputs.DevicePropertiesArgs.builder()
            .deviceModel(deviceModel?.applyValue({ args0 -> args0 }))
            .deviceVendor(deviceVendor?.applyValue({ args0 -> args0 }))
            .linkSpeedInMbps(linkSpeedInMbps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevicePropertiesArgs].
 */
@PulumiTagMarker
public class DevicePropertiesArgsBuilder internal constructor() {
    private var deviceModel: Output<String>? = null

    private var deviceVendor: Output<String>? = null

    private var linkSpeedInMbps: Output<Int>? = null

    /**
     * @param value Model of the device.
     */
    @JvmName("haqwraulwmuuknmo")
    public suspend fun deviceModel(`value`: Output<String>) {
        this.deviceModel = value
    }

    /**
     * @param value Name of the device Vendor.
     */
    @JvmName("vymxgrefsayfcrrt")
    public suspend fun deviceVendor(`value`: Output<String>) {
        this.deviceVendor = value
    }

    /**
     * @param value Link speed.
     */
    @JvmName("isxeqemoepjodjpe")
    public suspend fun linkSpeedInMbps(`value`: Output<Int>) {
        this.linkSpeedInMbps = value
    }

    /**
     * @param value Model of the device.
     */
    @JvmName("kdbrhbqpkhgbtvhr")
    public suspend fun deviceModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceModel = mapped
    }

    /**
     * @param value Name of the device Vendor.
     */
    @JvmName("xxbisobkmysaqwgt")
    public suspend fun deviceVendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceVendor = mapped
    }

    /**
     * @param value Link speed.
     */
    @JvmName("bgycuramgslrsqmr")
    public suspend fun linkSpeedInMbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkSpeedInMbps = mapped
    }

    internal fun build(): DevicePropertiesArgs = DevicePropertiesArgs(
        deviceModel = deviceModel,
        deviceVendor = deviceVendor,
        linkSpeedInMbps = linkSpeedInMbps,
    )
}
