@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.DnsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class containing DNS settings in a Traffic Manager profile.
 * @property relativeName The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
 * @property ttl The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
 */
public data class DnsConfigArgs(
    public val relativeName: Output<String>? = null,
    public val ttl: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.DnsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.DnsConfigArgs =
        com.pulumi.azurenative.network.inputs.DnsConfigArgs.builder()
            .relativeName(relativeName?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DnsConfigArgs].
 */
@PulumiTagMarker
public class DnsConfigArgsBuilder internal constructor() {
    private var relativeName: Output<String>? = null

    private var ttl: Output<Double>? = null

    /**
     * @param value The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
     */
    @JvmName("mhvsemmchrlfkohs")
    public suspend fun relativeName(`value`: Output<String>) {
        this.relativeName = value
    }

    /**
     * @param value The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
     */
    @JvmName("hajnnrepapdegkln")
    public suspend fun ttl(`value`: Output<Double>) {
        this.ttl = value
    }

    /**
     * @param value The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
     */
    @JvmName("kcprspjitutktdtv")
    public suspend fun relativeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeName = mapped
    }

    /**
     * @param value The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
     */
    @JvmName("vomkjsqwthdvtepq")
    public suspend fun ttl(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): DnsConfigArgs = DnsConfigArgs(
        relativeName = relativeName,
        ttl = ttl,
    )
}
