@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.EndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AlwaysServe
import com.pulumi.azurenative.network.kotlin.enums.EndpointMonitorStatus
import com.pulumi.azurenative.network.kotlin.enums.EndpointStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class representing a Traffic Manager endpoint.
 * @property alwaysServe If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
 * @property customHeaders List of custom headers.
 * @property endpointLocation Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
 * @property endpointMonitorStatus The monitoring status of the endpoint.
 * @property endpointStatus The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
 * @property geoMapping The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
 * @property minChildEndpoints The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property minChildEndpointsIPv4 The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property minChildEndpointsIPv6 The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property name The name of the resource
 * @property priority The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
 * @property subnets The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
 * @property target The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
 * @property targetResourceId The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
 * @property type The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
 * @property weight The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
 */
public data class EndpointArgs(
    public val alwaysServe: Output<Either<String, AlwaysServe>>? = null,
    public val customHeaders: Output<List<EndpointPropertiesCustomHeadersArgs>>? = null,
    public val endpointLocation: Output<String>? = null,
    public val endpointMonitorStatus: Output<Either<String, EndpointMonitorStatus>>? = null,
    public val endpointStatus: Output<Either<String, EndpointStatus>>? = null,
    public val geoMapping: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val minChildEndpoints: Output<Double>? = null,
    public val minChildEndpointsIPv4: Output<Double>? = null,
    public val minChildEndpointsIPv6: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Double>? = null,
    public val subnets: Output<List<EndpointPropertiesSubnetsArgs>>? = null,
    public val target: Output<String>? = null,
    public val targetResourceId: Output<String>? = null,
    public val type: Output<String>? = null,
    public val weight: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.EndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.EndpointArgs =
        com.pulumi.azurenative.network.inputs.EndpointArgs.builder()
            .alwaysServe(
                alwaysServe?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customHeaders(
                customHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .endpointLocation(endpointLocation?.applyValue({ args0 -> args0 }))
            .endpointMonitorStatus(
                endpointMonitorStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .endpointStatus(
                endpointStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .geoMapping(geoMapping?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .minChildEndpoints(minChildEndpoints?.applyValue({ args0 -> args0 }))
            .minChildEndpointsIPv4(minChildEndpointsIPv4?.applyValue({ args0 -> args0 }))
            .minChildEndpointsIPv6(minChildEndpointsIPv6?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .target(target?.applyValue({ args0 -> args0 }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var alwaysServe: Output<Either<String, AlwaysServe>>? = null

    private var customHeaders: Output<List<EndpointPropertiesCustomHeadersArgs>>? = null

    private var endpointLocation: Output<String>? = null

    private var endpointMonitorStatus: Output<Either<String, EndpointMonitorStatus>>? = null

    private var endpointStatus: Output<Either<String, EndpointStatus>>? = null

    private var geoMapping: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var minChildEndpoints: Output<Double>? = null

    private var minChildEndpointsIPv4: Output<Double>? = null

    private var minChildEndpointsIPv6: Output<Double>? = null

    private var name: Output<String>? = null

    private var priority: Output<Double>? = null

    private var subnets: Output<List<EndpointPropertiesSubnetsArgs>>? = null

    private var target: Output<String>? = null

    private var targetResourceId: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<Double>? = null

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("fhulwdrgpcujrolk")
    public suspend fun alwaysServe(`value`: Output<Either<String, AlwaysServe>>) {
        this.alwaysServe = value
    }

    /**
     * @param value List of custom headers.
     */
    @JvmName("obnilmmtnwqocpvx")
    public suspend fun customHeaders(`value`: Output<List<EndpointPropertiesCustomHeadersArgs>>) {
        this.customHeaders = value
    }

    @JvmName("dhxrplpqgvcwputt")
    public suspend fun customHeaders(vararg values: Output<EndpointPropertiesCustomHeadersArgs>) {
        this.customHeaders = Output.all(values.asList())
    }

    /**
     * @param values List of custom headers.
     */
    @JvmName("kejqmrfwblrbqjts")
    public suspend fun customHeaders(values: List<Output<EndpointPropertiesCustomHeadersArgs>>) {
        this.customHeaders = Output.all(values)
    }

    /**
     * @param value Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
     */
    @JvmName("gdnwcjjwddemfnby")
    public suspend fun endpointLocation(`value`: Output<String>) {
        this.endpointLocation = value
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("ktlxyqipuoiwxqdp")
    public suspend fun endpointMonitorStatus(`value`: Output<Either<String, EndpointMonitorStatus>>) {
        this.endpointMonitorStatus = value
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("qjduwdgfsbuuxlrw")
    public suspend fun endpointStatus(`value`: Output<Either<String, EndpointStatus>>) {
        this.endpointStatus = value
    }

    /**
     * @param value The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("dajkgtmishbvimpu")
    public suspend fun geoMapping(`value`: Output<List<String>>) {
        this.geoMapping = value
    }

    @JvmName("nihmtqlmmsvgrvii")
    public suspend fun geoMapping(vararg values: Output<String>) {
        this.geoMapping = Output.all(values.asList())
    }

    /**
     * @param values The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("cujrtnaaxbpdnfhb")
    public suspend fun geoMapping(values: List<Output<String>>) {
        this.geoMapping = Output.all(values)
    }

    /**
     * @param value Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JvmName("apcejbqvjejuwlko")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("aecmuotjvlqpppov")
    public suspend fun minChildEndpoints(`value`: Output<Double>) {
        this.minChildEndpoints = value
    }

    /**
     * @param value The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("juvtfxhdmeiyyntn")
    public suspend fun minChildEndpointsIPv4(`value`: Output<Double>) {
        this.minChildEndpointsIPv4 = value
    }

    /**
     * @param value The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("mfxneitokgpxnsxd")
    public suspend fun minChildEndpointsIPv6(`value`: Output<Double>) {
        this.minChildEndpointsIPv6 = value
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("xrubrxytsdvrdoao")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     */
    @JvmName("yroticllyydhgmvd")
    public suspend fun priority(`value`: Output<Double>) {
        this.priority = value
    }

    /**
     * @param value The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("aontidpuynhfutrk")
    public suspend fun subnets(`value`: Output<List<EndpointPropertiesSubnetsArgs>>) {
        this.subnets = value
    }

    @JvmName("rpmasefxacvncpih")
    public suspend fun subnets(vararg values: Output<EndpointPropertiesSubnetsArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("dfgajdopxpbuvams")
    public suspend fun subnets(values: List<Output<EndpointPropertiesSubnetsArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
     */
    @JvmName("fductdkwyfqxwjxr")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
     */
    @JvmName("kokjvbwqhlqlmskx")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JvmName("yythbbvjmevikuuh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
     */
    @JvmName("rhmkyahnqmcxbiho")
    public suspend fun weight(`value`: Output<Double>) {
        this.weight = value
    }

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("mlkgkaehklwjbokp")
    public suspend fun alwaysServe(`value`: Either<String, AlwaysServe>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysServe = mapped
    }

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("otqtafwsocmxcdsj")
    public fun alwaysServe(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlwaysServe>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysServe = mapped
    }

    /**
     * @param value If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    @JvmName("lqirrnsyrtlllgkb")
    public fun alwaysServe(`value`: AlwaysServe) {
        val toBeMapped = Either.ofRight<String, AlwaysServe>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alwaysServe = mapped
    }

    /**
     * @param value List of custom headers.
     */
    @JvmName("qoxfseorftyjjeoi")
    public suspend fun customHeaders(`value`: List<EndpointPropertiesCustomHeadersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("swxqfweaywaiemup")
    public suspend
    fun customHeaders(argument: List<suspend EndpointPropertiesCustomHeadersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesCustomHeadersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("hpyytvbcabdxtjls")
    public suspend fun customHeaders(
        vararg
        argument: suspend EndpointPropertiesCustomHeadersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesCustomHeadersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument List of custom headers.
     */
    @JvmName("vghlhnjswbylxmll")
    public suspend
    fun customHeaders(argument: suspend EndpointPropertiesCustomHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointPropertiesCustomHeadersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param values List of custom headers.
     */
    @JvmName("trkjbtmdcaoxtoew")
    public suspend fun customHeaders(vararg values: EndpointPropertiesCustomHeadersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
     */
    @JvmName("uojnoyqxpcxqxwwg")
    public suspend fun endpointLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointLocation = mapped
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("spjunaknbthxjfpc")
    public suspend fun endpointMonitorStatus(`value`: Either<String, EndpointMonitorStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointMonitorStatus = mapped
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("fnkvwssjvcjivtub")
    public fun endpointMonitorStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointMonitorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointMonitorStatus = mapped
    }

    /**
     * @param value The monitoring status of the endpoint.
     */
    @JvmName("sfqfuvpusplkvslh")
    public fun endpointMonitorStatus(`value`: EndpointMonitorStatus) {
        val toBeMapped = Either.ofRight<String, EndpointMonitorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointMonitorStatus = mapped
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("agmdjjjknnmohbeh")
    public suspend fun endpointStatus(`value`: Either<String, EndpointStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointStatus = mapped
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("rtbcdrfgyfucyywg")
    public fun endpointStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointStatus = mapped
    }

    /**
     * @param value The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    @JvmName("hrgyammqkyywgyhb")
    public fun endpointStatus(`value`: EndpointStatus) {
        val toBeMapped = Either.ofRight<String, EndpointStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointStatus = mapped
    }

    /**
     * @param value The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("nphptworsrqhitbp")
    public suspend fun geoMapping(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMapping = mapped
    }

    /**
     * @param values The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JvmName("kivclsdmohsdjphb")
    public suspend fun geoMapping(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoMapping = mapped
    }

    /**
     * @param value Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JvmName("cexrxmqqfcssowdj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("oiidrthdwxhixrqx")
    public suspend fun minChildEndpoints(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minChildEndpoints = mapped
    }

    /**
     * @param value The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("ybliqcjlcdjqwcin")
    public suspend fun minChildEndpointsIPv4(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minChildEndpointsIPv4 = mapped
    }

    /**
     * @param value The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JvmName("darxhwqvbnxnniwb")
    public suspend fun minChildEndpointsIPv6(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minChildEndpointsIPv6 = mapped
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("jfyfbgflqgckjlao")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     */
    @JvmName("fhfnvwkvnnggkltd")
    public suspend fun priority(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("sesaffeynjikkaqq")
    public suspend fun subnets(`value`: List<EndpointPropertiesSubnetsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("nrkniaijopmwping")
    public suspend
    fun subnets(argument: List<suspend EndpointPropertiesSubnetsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesSubnetsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("honlttbnkdoifywx")
    public suspend fun subnets(
        vararg
        argument: suspend EndpointPropertiesSubnetsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesSubnetsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("jogxrpkhiunqwawe")
    public suspend fun subnets(argument: suspend EndpointPropertiesSubnetsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointPropertiesSubnetsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JvmName("boidckwatesbuquy")
    public suspend fun subnets(vararg values: EndpointPropertiesSubnetsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
     */
    @JvmName("uergkglkmphultyg")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
     */
    @JvmName("mcjkymneyjaqyvbn")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    /**
     * @param value The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JvmName("oipqrxdueevyshib")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
     */
    @JvmName("ovsbpgaxxcwjlbvg")
    public suspend fun weight(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        alwaysServe = alwaysServe,
        customHeaders = customHeaders,
        endpointLocation = endpointLocation,
        endpointMonitorStatus = endpointMonitorStatus,
        endpointStatus = endpointStatus,
        geoMapping = geoMapping,
        id = id,
        minChildEndpoints = minChildEndpoints,
        minChildEndpointsIPv4 = minChildEndpointsIPv4,
        minChildEndpointsIPv6 = minChildEndpointsIPv6,
        name = name,
        priority = priority,
        subnets = subnets,
        target = target,
        targetResourceId = targetResourceId,
        type = type,
        weight = weight,
    )
}
