@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExclusionManagedRuleGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule group to use for exclusion.
 * @property ruleGroupName The managed rule group for exclusion.
 * @property rules List of rules that will be excluded. If none specified, all rules in the group will be excluded.
 */
public data class ExclusionManagedRuleGroupArgs(
    public val ruleGroupName: Output<String>,
    public val rules: Output<List<ExclusionManagedRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExclusionManagedRuleGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExclusionManagedRuleGroupArgs =
        com.pulumi.azurenative.network.inputs.ExclusionManagedRuleGroupArgs.builder()
            .ruleGroupName(ruleGroupName.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExclusionManagedRuleGroupArgs].
 */
@PulumiTagMarker
public class ExclusionManagedRuleGroupArgsBuilder internal constructor() {
    private var ruleGroupName: Output<String>? = null

    private var rules: Output<List<ExclusionManagedRuleArgs>>? = null

    /**
     * @param value The managed rule group for exclusion.
     */
    @JvmName("xwlcueqcnpfycria")
    public suspend fun ruleGroupName(`value`: Output<String>) {
        this.ruleGroupName = value
    }

    /**
     * @param value List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("tixwbjhdbunydbsc")
    public suspend fun rules(`value`: Output<List<ExclusionManagedRuleArgs>>) {
        this.rules = value
    }

    @JvmName("kpsxyamgysxlunjp")
    public suspend fun rules(vararg values: Output<ExclusionManagedRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("swxtgbabbysbsrss")
    public suspend fun rules(values: List<Output<ExclusionManagedRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The managed rule group for exclusion.
     */
    @JvmName("ydpsrywiebvbslir")
    public suspend fun ruleGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupName = mapped
    }

    /**
     * @param value List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("gcowtisoomxdqxqb")
    public suspend fun rules(`value`: List<ExclusionManagedRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("qamyowecqhrkyfgn")
    public suspend fun rules(argument: List<suspend ExclusionManagedRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExclusionManagedRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("wkhuwyilpbbyidnj")
    public suspend fun rules(vararg argument: suspend ExclusionManagedRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExclusionManagedRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("obukfhodifabnvxx")
    public suspend fun rules(argument: suspend ExclusionManagedRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExclusionManagedRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JvmName("sfgrafheooiuvydc")
    public suspend fun rules(vararg values: ExclusionManagedRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): ExclusionManagedRuleGroupArgs = ExclusionManagedRuleGroupArgs(
        ruleGroupName = ruleGroupName ?: throw PulumiNullFieldException("ruleGroupName"),
        rules = rules,
    )
}
