@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRoutePeeringState
import com.pulumi.azurenative.network.kotlin.enums.ExpressRoutePeeringType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Peering in an ExpressRouteCircuit resource.
 * @property azureASN The Azure ASN.
 * @property connections The list of circuit connections associated with Azure Private Peering for this circuit.
 * @property gatewayManagerEtag The GatewayManager Etag.
 * @property id Resource ID.
 * @property ipv6PeeringConfig The IPv6 peering configuration.
 * @property microsoftPeeringConfig The Microsoft peering configuration.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerASN The peer ASN.
 * @property peeringType The peering type.
 * @property primaryAzurePort The primary port.
 * @property primaryPeerAddressPrefix The primary address prefix.
 * @property routeFilter The reference to the RouteFilter resource.
 * @property secondaryAzurePort The secondary port.
 * @property secondaryPeerAddressPrefix The secondary address prefix.
 * @property sharedKey The shared key.
 * @property state The peering state.
 * @property stats The peering stats of express route circuit.
 * @property vlanId The VLAN ID.
 */
public data class ExpressRouteCircuitPeeringArgs(
    public val azureASN: Output<Int>? = null,
    public val connections: Output<List<ExpressRouteCircuitConnectionArgs>>? = null,
    public val gatewayManagerEtag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val ipv6PeeringConfig: Output<Ipv6ExpressRouteCircuitPeeringConfigArgs>? = null,
    public val microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val peerASN: Output<Double>? = null,
    public val peeringType: Output<Either<String, ExpressRoutePeeringType>>? = null,
    public val primaryAzurePort: Output<String>? = null,
    public val primaryPeerAddressPrefix: Output<String>? = null,
    public val routeFilter: Output<SubResourceArgs>? = null,
    public val secondaryAzurePort: Output<String>? = null,
    public val secondaryPeerAddressPrefix: Output<String>? = null,
    public val sharedKey: Output<String>? = null,
    public val state: Output<Either<String, ExpressRoutePeeringState>>? = null,
    public val stats: Output<ExpressRouteCircuitStatsArgs>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringArgs.builder()
            .azureASN(azureASN?.applyValue({ args0 -> args0 }))
            .connections(
                connections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gatewayManagerEtag(gatewayManagerEtag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipv6PeeringConfig(ipv6PeeringConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .microsoftPeeringConfig(
                microsoftPeeringConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .peerASN(peerASN?.applyValue({ args0 -> args0 }))
            .peeringType(
                peeringType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .primaryAzurePort(primaryAzurePort?.applyValue({ args0 -> args0 }))
            .primaryPeerAddressPrefix(primaryPeerAddressPrefix?.applyValue({ args0 -> args0 }))
            .routeFilter(routeFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secondaryAzurePort(secondaryAzurePort?.applyValue({ args0 -> args0 }))
            .secondaryPeerAddressPrefix(secondaryPeerAddressPrefix?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stats(stats?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitPeeringArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitPeeringArgsBuilder internal constructor() {
    private var azureASN: Output<Int>? = null

    private var connections: Output<List<ExpressRouteCircuitConnectionArgs>>? = null

    private var gatewayManagerEtag: Output<String>? = null

    private var id: Output<String>? = null

    private var ipv6PeeringConfig: Output<Ipv6ExpressRouteCircuitPeeringConfigArgs>? = null

    private var microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigArgs>? = null

    private var name: Output<String>? = null

    private var peerASN: Output<Double>? = null

    private var peeringType: Output<Either<String, ExpressRoutePeeringType>>? = null

    private var primaryAzurePort: Output<String>? = null

    private var primaryPeerAddressPrefix: Output<String>? = null

    private var routeFilter: Output<SubResourceArgs>? = null

    private var secondaryAzurePort: Output<String>? = null

    private var secondaryPeerAddressPrefix: Output<String>? = null

    private var sharedKey: Output<String>? = null

    private var state: Output<Either<String, ExpressRoutePeeringState>>? = null

    private var stats: Output<ExpressRouteCircuitStatsArgs>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value The Azure ASN.
     */
    @JvmName("nmxttitvbyyjuxle")
    public suspend fun azureASN(`value`: Output<Int>) {
        this.azureASN = value
    }

    /**
     * @param value The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("drhmkptvmheghaww")
    public suspend fun connections(`value`: Output<List<ExpressRouteCircuitConnectionArgs>>) {
        this.connections = value
    }

    @JvmName("hqowtkaixijpiqsy")
    public suspend fun connections(vararg values: Output<ExpressRouteCircuitConnectionArgs>) {
        this.connections = Output.all(values.asList())
    }

    /**
     * @param values The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("iidvqboxkraordkh")
    public suspend fun connections(values: List<Output<ExpressRouteCircuitConnectionArgs>>) {
        this.connections = Output.all(values)
    }

    /**
     * @param value The GatewayManager Etag.
     */
    @JvmName("ytwnqcsjrljwogwn")
    public suspend fun gatewayManagerEtag(`value`: Output<String>) {
        this.gatewayManagerEtag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("asodrswayjbaeslk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The IPv6 peering configuration.
     */
    @JvmName("naomaxlwunanmvuv")
    public suspend fun ipv6PeeringConfig(`value`: Output<Ipv6ExpressRouteCircuitPeeringConfigArgs>) {
        this.ipv6PeeringConfig = value
    }

    /**
     * @param value The Microsoft peering configuration.
     */
    @JvmName("qvuoiaynxwrprhdy")
    public suspend fun microsoftPeeringConfig(`value`: Output<ExpressRouteCircuitPeeringConfigArgs>) {
        this.microsoftPeeringConfig = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("umxrurrtftiyrrdx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The peer ASN.
     */
    @JvmName("dwylmkldtqssuhsy")
    public suspend fun peerASN(`value`: Output<Double>) {
        this.peerASN = value
    }

    /**
     * @param value The peering type.
     */
    @JvmName("pviavshaohpiwhkh")
    public suspend fun peeringType(`value`: Output<Either<String, ExpressRoutePeeringType>>) {
        this.peeringType = value
    }

    /**
     * @param value The primary port.
     */
    @JvmName("npogokulqhavjpdw")
    public suspend fun primaryAzurePort(`value`: Output<String>) {
        this.primaryAzurePort = value
    }

    /**
     * @param value The primary address prefix.
     */
    @JvmName("aradfnntamwfktxf")
    public suspend fun primaryPeerAddressPrefix(`value`: Output<String>) {
        this.primaryPeerAddressPrefix = value
    }

    /**
     * @param value The reference to the RouteFilter resource.
     */
    @JvmName("vgrgvsexynshmena")
    public suspend fun routeFilter(`value`: Output<SubResourceArgs>) {
        this.routeFilter = value
    }

    /**
     * @param value The secondary port.
     */
    @JvmName("bspeynxhwamtoyvs")
    public suspend fun secondaryAzurePort(`value`: Output<String>) {
        this.secondaryAzurePort = value
    }

    /**
     * @param value The secondary address prefix.
     */
    @JvmName("kpryjxiyrlorboeg")
    public suspend fun secondaryPeerAddressPrefix(`value`: Output<String>) {
        this.secondaryPeerAddressPrefix = value
    }

    /**
     * @param value The shared key.
     */
    @JvmName("acgijpqslchcxtra")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value The peering state.
     */
    @JvmName("abtqdcyyxtmjsqlb")
    public suspend fun state(`value`: Output<Either<String, ExpressRoutePeeringState>>) {
        this.state = value
    }

    /**
     * @param value The peering stats of express route circuit.
     */
    @JvmName("xybsecpusqxtsmph")
    public suspend fun stats(`value`: Output<ExpressRouteCircuitStatsArgs>) {
        this.stats = value
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("jofsatijeyqihrmy")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value The Azure ASN.
     */
    @JvmName("mvvyxclkxpwvsmqm")
    public suspend fun azureASN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureASN = mapped
    }

    /**
     * @param value The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("thjuethlcxliinew")
    public suspend fun connections(`value`: List<ExpressRouteCircuitConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param argument The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("kvcfeumdaeerktwl")
    public suspend
    fun connections(argument: List<suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("hwroepnoqmmyqiqp")
    public suspend fun connections(
        vararg
        argument: suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExpressRouteCircuitConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("lkbposnrimykxvue")
    public suspend
    fun connections(argument: suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExpressRouteCircuitConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param values The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    @JvmName("krwvotciwlnocbrk")
    public suspend fun connections(vararg values: ExpressRouteCircuitConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param value The GatewayManager Etag.
     */
    @JvmName("qpoebsunirgklpnw")
    public suspend fun gatewayManagerEtag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayManagerEtag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("avyqmehymorohyjt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The IPv6 peering configuration.
     */
    @JvmName("djnafcjmybvrlwrb")
    public suspend fun ipv6PeeringConfig(`value`: Ipv6ExpressRouteCircuitPeeringConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6PeeringConfig = mapped
    }

    /**
     * @param argument The IPv6 peering configuration.
     */
    @JvmName("psefuprdtgbqfqrx")
    public suspend
    fun ipv6PeeringConfig(argument: suspend Ipv6ExpressRouteCircuitPeeringConfigArgsBuilder.() -> Unit) {
        val toBeMapped = Ipv6ExpressRouteCircuitPeeringConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ipv6PeeringConfig = mapped
    }

    /**
     * @param value The Microsoft peering configuration.
     */
    @JvmName("qvkxglcagticwljt")
    public suspend fun microsoftPeeringConfig(`value`: ExpressRouteCircuitPeeringConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftPeeringConfig = mapped
    }

    /**
     * @param argument The Microsoft peering configuration.
     */
    @JvmName("xxmqfamebmgkekwm")
    public suspend
    fun microsoftPeeringConfig(argument: suspend ExpressRouteCircuitPeeringConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitPeeringConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.microsoftPeeringConfig = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("cjcucfhekrphwwkn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The peer ASN.
     */
    @JvmName("sjobwqrgewmqtkmh")
    public suspend fun peerASN(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerASN = mapped
    }

    /**
     * @param value The peering type.
     */
    @JvmName("anxwgshymlrypmak")
    public suspend fun peeringType(`value`: Either<String, ExpressRoutePeeringType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringType = mapped
    }

    /**
     * @param value The peering type.
     */
    @JvmName("cbhatxyhdwiengfw")
    public fun peeringType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRoutePeeringType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringType = mapped
    }

    /**
     * @param value The peering type.
     */
    @JvmName("utioqvlbtlcqdhkx")
    public fun peeringType(`value`: ExpressRoutePeeringType) {
        val toBeMapped = Either.ofRight<String, ExpressRoutePeeringType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringType = mapped
    }

    /**
     * @param value The primary port.
     */
    @JvmName("vapnnwlyafavryqt")
    public suspend fun primaryAzurePort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryAzurePort = mapped
    }

    /**
     * @param value The primary address prefix.
     */
    @JvmName("ytaaugaknggtqyhh")
    public suspend fun primaryPeerAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryPeerAddressPrefix = mapped
    }

    /**
     * @param value The reference to the RouteFilter resource.
     */
    @JvmName("riespaokugjujpql")
    public suspend fun routeFilter(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilter = mapped
    }

    /**
     * @param argument The reference to the RouteFilter resource.
     */
    @JvmName("suhekuxcxkeoqkas")
    public suspend fun routeFilter(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeFilter = mapped
    }

    /**
     * @param value The secondary port.
     */
    @JvmName("fkqrrumrrinifxig")
    public suspend fun secondaryAzurePort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryAzurePort = mapped
    }

    /**
     * @param value The secondary address prefix.
     */
    @JvmName("ycbiimttiarjmlvd")
    public suspend fun secondaryPeerAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPeerAddressPrefix = mapped
    }

    /**
     * @param value The shared key.
     */
    @JvmName("iqeqkxqyytrjtsbt")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value The peering state.
     */
    @JvmName("jbinvdbsaxxqmhoo")
    public suspend fun state(`value`: Either<String, ExpressRoutePeeringState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The peering state.
     */
    @JvmName("pvsnlktjlfjblnvq")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRoutePeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The peering state.
     */
    @JvmName("xukycyvtfiltcfdt")
    public fun state(`value`: ExpressRoutePeeringState) {
        val toBeMapped = Either.ofRight<String, ExpressRoutePeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The peering stats of express route circuit.
     */
    @JvmName("skldayunslggwndv")
    public suspend fun stats(`value`: ExpressRouteCircuitStatsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stats = mapped
    }

    /**
     * @param argument The peering stats of express route circuit.
     */
    @JvmName("rwauexogikvpdekj")
    public suspend fun stats(argument: suspend ExpressRouteCircuitStatsArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitStatsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stats = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("bempocfvlhsxcuxf")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): ExpressRouteCircuitPeeringArgs = ExpressRouteCircuitPeeringArgs(
        azureASN = azureASN,
        connections = connections,
        gatewayManagerEtag = gatewayManagerEtag,
        id = id,
        ipv6PeeringConfig = ipv6PeeringConfig,
        microsoftPeeringConfig = microsoftPeeringConfig,
        name = name,
        peerASN = peerASN,
        peeringType = peeringType,
        primaryAzurePort = primaryAzurePort,
        primaryPeerAddressPrefix = primaryPeerAddressPrefix,
        routeFilter = routeFilter,
        secondaryAzurePort = secondaryAzurePort,
        secondaryPeerAddressPrefix = secondaryPeerAddressPrefix,
        sharedKey = sharedKey,
        state = state,
        stats = stats,
        vlanId = vlanId,
    )
}
