@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesBoundsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Minimum and maximum number of scale units to deploy.
 * @property max Maximum number of scale units deployed for ExpressRoute gateway.
 * @property min Minimum number of scale units deployed for ExpressRoute gateway.
 */
public data class ExpressRouteGatewayPropertiesBoundsArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesBoundsArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesBoundsArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesBoundsArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteGatewayPropertiesBoundsArgs].
 */
@PulumiTagMarker
public class ExpressRouteGatewayPropertiesBoundsArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value Maximum number of scale units deployed for ExpressRoute gateway.
     */
    @JvmName("iwatcuqljeqwlonn")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value Minimum number of scale units deployed for ExpressRoute gateway.
     */
    @JvmName("ahucllfisqcklvml")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value Maximum number of scale units deployed for ExpressRoute gateway.
     */
    @JvmName("roreeuspxsdmoxhn")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value Minimum number of scale units deployed for ExpressRoute gateway.
     */
    @JvmName("gebswqjtqpmoithk")
    public suspend fun min(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): ExpressRouteGatewayPropertiesBoundsArgs =
        ExpressRouteGatewayPropertiesBoundsArgs(
            max = max,
            min = min,
        )
}
