@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyIntrusionDetectionProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Intrusion detection bypass traffic specification.
 * @property description Description of the bypass traffic rule.
 * @property destinationAddresses List of destination IP addresses or ranges for this rule.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports or ranges.
 * @property name Name of the bypass traffic rule.
 * @property protocol The rule bypass protocol.
 * @property sourceAddresses List of source IP addresses or ranges for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationIpGroups: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, FirewallPolicyIntrusionDetectionProtocol>>? = null,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationIpGroups(destinationIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs].
 */
@PulumiTagMarker
public class FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder internal
constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationIpGroups: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, FirewallPolicyIntrusionDetectionProtocol>>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    /**
     * @param value Description of the bypass traffic rule.
     */
    @JvmName("ksesruuvhjsxpnks")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or ranges for this rule.
     */
    @JvmName("mxskdhlckkytnevt")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("kkmfxhqgofccmubb")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or ranges for this rule.
     */
    @JvmName("lpahdljgghakdeds")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("ycwgcupjiwxmngqc")
    public suspend fun destinationIpGroups(`value`: Output<List<String>>) {
        this.destinationIpGroups = value
    }

    @JvmName("bmhohcgytkocfwog")
    public suspend fun destinationIpGroups(vararg values: Output<String>) {
        this.destinationIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("tfrubgmlsrvppevu")
    public suspend fun destinationIpGroups(values: List<Output<String>>) {
        this.destinationIpGroups = Output.all(values)
    }

    /**
     * @param value List of destination ports or ranges.
     */
    @JvmName("hwyfjuoeddpupthr")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("arhtjmirjnaaykml")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports or ranges.
     */
    @JvmName("rqxsxfdvrpobnxft")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Name of the bypass traffic rule.
     */
    @JvmName("foohiotuesilhwcr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("onypchshiryrpxpi")
    public suspend
    fun protocol(`value`: Output<Either<String, FirewallPolicyIntrusionDetectionProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value List of source IP addresses or ranges for this rule.
     */
    @JvmName("cieuqxjemsgunyuh")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("yucnehkovsqdknrp")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses or ranges for this rule.
     */
    @JvmName("lessibxviexfkhxt")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("rywerndjgjgbgaaa")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("egucfjincrwdrugy")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("ilpvlixbvlphxhfb")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value Description of the bypass traffic rule.
     */
    @JvmName("wuhgqumpdlthhqtk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or ranges for this rule.
     */
    @JvmName("csswatayjhplqcxw")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or ranges for this rule.
     */
    @JvmName("iinkrvuteeynmpbo")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("sirdxhlbkokaqcge")
    public suspend fun destinationIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("vqkdhtnfljojskxy")
    public suspend fun destinationIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param value List of destination ports or ranges.
     */
    @JvmName("ergipdmyxeupwciu")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports or ranges.
     */
    @JvmName("daskhmsyjlnlkvap")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Name of the bypass traffic rule.
     */
    @JvmName("kuntaadttckynlmd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("gpnptwawnxpgjoxy")
    public suspend fun protocol(`value`: Either<String, FirewallPolicyIntrusionDetectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("tgbsuxpmhsrkxvil")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyIntrusionDetectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("lwpmnrfufwxmriiw")
    public fun protocol(`value`: FirewallPolicyIntrusionDetectionProtocol) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyIntrusionDetectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value List of source IP addresses or ranges for this rule.
     */
    @JvmName("lrhudvmracepmptk")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses or ranges for this rule.
     */
    @JvmName("saipyomgufreuodw")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("totwwvilrrhshmpc")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("kalitxjdseryhgjq")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    internal fun build(): FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs =
        FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs(
            description = description,
            destinationAddresses = destinationAddresses,
            destinationIpGroups = destinationIpGroups,
            destinationPorts = destinationPorts,
            name = name,
            protocol = protocol,
            sourceAddresses = sourceAddresses,
            sourceIpGroups = sourceIpGroups,
        )
}
