@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicySQLArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SQL Settings in Firewall Policy.
 * @property allowSqlRedirect A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
 */
public data class FirewallPolicySQLArgs(
    public val allowSqlRedirect: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicySQLArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicySQLArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicySQLArgs.builder()
            .allowSqlRedirect(allowSqlRedirect?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicySQLArgs].
 */
@PulumiTagMarker
public class FirewallPolicySQLArgsBuilder internal constructor() {
    private var allowSqlRedirect: Output<Boolean>? = null

    /**
     * @param value A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
     */
    @JvmName("cwakabeppdlkreoq")
    public suspend fun allowSqlRedirect(`value`: Output<Boolean>) {
        this.allowSqlRedirect = value
    }

    /**
     * @param value A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
     */
    @JvmName("lclidfbrdagqrqsm")
    public suspend fun allowSqlRedirect(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSqlRedirect = mapped
    }

    internal fun build(): FirewallPolicySQLArgs = FirewallPolicySQLArgs(
        allowSqlRedirect = allowSqlRedirect,
    )
}
