@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontDoorMatchConditionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorMatchVariable
import com.pulumi.azurenative.network.kotlin.enums.Operator
import com.pulumi.azurenative.network.kotlin.enums.TransformType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Define a match condition.
 * @property matchValue List of possible match values.
 * @property matchVariable Request variable to compare with.
 * @property negateCondition Describes if the result of this condition should be negated.
 * @property operator Comparison type to use for matching with the variable value.
 * @property selector Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
 * @property transforms List of transforms.
 */
public data class FrontDoorMatchConditionArgs(
    public val matchValue: Output<List<String>>,
    public val matchVariable: Output<Either<String, FrontDoorMatchVariable>>,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, Operator>>,
    public val selector: Output<String>? = null,
    public val transforms: Output<List<Either<String, TransformType>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontDoorMatchConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontDoorMatchConditionArgs =
        com.pulumi.azurenative.network.inputs.FrontDoorMatchConditionArgs.builder()
            .matchValue(matchValue.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchVariable(
                matchVariable.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [FrontDoorMatchConditionArgs].
 */
@PulumiTagMarker
public class FrontDoorMatchConditionArgsBuilder internal constructor() {
    private var matchValue: Output<List<String>>? = null

    private var matchVariable: Output<Either<String, FrontDoorMatchVariable>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var selector: Output<String>? = null

    private var transforms: Output<List<Either<String, TransformType>>>? = null

    /**
     * @param value List of possible match values.
     */
    @JvmName("dlhbbpycwcjfvvcn")
    public suspend fun matchValue(`value`: Output<List<String>>) {
        this.matchValue = value
    }

    @JvmName("naffajbbmkrofvie")
    public suspend fun matchValue(vararg values: Output<String>) {
        this.matchValue = Output.all(values.asList())
    }

    /**
     * @param values List of possible match values.
     */
    @JvmName("feplxettaqsnieum")
    public suspend fun matchValue(values: List<Output<String>>) {
        this.matchValue = Output.all(values)
    }

    /**
     * @param value Request variable to compare with.
     */
    @JvmName("aabgudnfmvesoggw")
    public suspend fun matchVariable(`value`: Output<Either<String, FrontDoorMatchVariable>>) {
        this.matchVariable = value
    }

    /**
     * @param value Describes if the result of this condition should be negated.
     */
    @JvmName("jilaykiaiewwahre")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Comparison type to use for matching with the variable value.
     */
    @JvmName("jdqhgqdtgxxtsowy")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
     */
    @JvmName("uxyplmwmgylsxgun")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value List of transforms.
     */
    @JvmName("tcmdwcjagahlboqx")
    public suspend fun transforms(`value`: Output<List<Either<String, TransformType>>>) {
        this.transforms = value
    }

    @JvmName("qtqyxotoockxkjgu")
    public suspend fun transforms(vararg values: Output<Either<String, TransformType>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms.
     */
    @JvmName("tfsrkqwisgrksyrc")
    public suspend fun transforms(values: List<Output<Either<String, TransformType>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value List of possible match values.
     */
    @JvmName("qklxquvthefghmvl")
    public suspend fun matchValue(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValue = mapped
    }

    /**
     * @param values List of possible match values.
     */
    @JvmName("fogucvamhecjtfny")
    public suspend fun matchValue(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValue = mapped
    }

    /**
     * @param value Request variable to compare with.
     */
    @JvmName("cdqpincpedigofpa")
    public suspend fun matchVariable(`value`: Either<String, FrontDoorMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Request variable to compare with.
     */
    @JvmName("dyvsrcvjxxltmuxp")
    public fun matchVariable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Request variable to compare with.
     */
    @JvmName("thvtwhahridbvxjq")
    public fun matchVariable(`value`: FrontDoorMatchVariable) {
        val toBeMapped = Either.ofRight<String, FrontDoorMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Describes if the result of this condition should be negated.
     */
    @JvmName("huucduoskbvxkdeq")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Comparison type to use for matching with the variable value.
     */
    @JvmName("gnallrurvfujvbof")
    public suspend fun `operator`(`value`: Either<String, Operator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Comparison type to use for matching with the variable value.
     */
    @JvmName("qfxtbjpumfjmjdwp")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Comparison type to use for matching with the variable value.
     */
    @JvmName("damqtvkscrwiltoj")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
     */
    @JvmName("bsnyrprarfrfasij")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value List of transforms.
     */
    @JvmName("lgwcisydmpwxlfqi")
    public suspend fun transforms(`value`: List<Either<String, TransformType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms.
     */
    @JvmName("aqsipawgsxqveltc")
    public suspend fun transforms(vararg values: Either<String, TransformType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    internal fun build(): FrontDoorMatchConditionArgs = FrontDoorMatchConditionArgs(
        matchValue = matchValue ?: throw PulumiNullFieldException("matchValue"),
        matchVariable = matchVariable ?: throw PulumiNullFieldException("matchVariable"),
        negateCondition = negateCondition,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        selector = selector,
        transforms = transforms,
    )
}
