@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetActiveSessionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bastionHostName The name of the Bastion Host.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetActiveSessionsPlainArgs(
    public val bastionHostName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetActiveSessionsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetActiveSessionsPlainArgs =
        com.pulumi.azurenative.network.inputs.GetActiveSessionsPlainArgs.builder()
            .bastionHostName(bastionHostName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActiveSessionsPlainArgs].
 */
@PulumiTagMarker
public class GetActiveSessionsPlainArgsBuilder internal constructor() {
    private var bastionHostName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Bastion Host.
     */
    @JvmName("nbevurcmgaqeayvj")
    public suspend fun bastionHostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bastionHostName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lwqmsvwdfuvntyyf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetActiveSessionsPlainArgs = GetActiveSessionsPlainArgs(
        bastionHostName = bastionHostName ?: throw PulumiNullFieldException("bastionHostName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
