@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetApplicationGatewayPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationGatewayName The name of the application gateway.
 * @property connectionName The name of the application gateway private endpoint connection.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetApplicationGatewayPrivateEndpointConnectionPlainArgs(
    public val applicationGatewayName: String,
    public val connectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetApplicationGatewayPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetApplicationGatewayPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetApplicationGatewayPrivateEndpointConnectionPlainArgs.builder()
            .applicationGatewayName(applicationGatewayName.let({ args0 -> args0 }))
            .connectionName(connectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationGatewayPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationGatewayPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var applicationGatewayName: String? = null

    private var connectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("cnrpksorvucvhxhv")
    public suspend fun applicationGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationGatewayName = mapped
    }

    /**
     * @param value The name of the application gateway private endpoint connection.
     */
    @JvmName("dldrephuhgyuwbir")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ifucwsfupubfdbmd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationGatewayPrivateEndpointConnectionPlainArgs =
        GetApplicationGatewayPrivateEndpointConnectionPlainArgs(
            applicationGatewayName = applicationGatewayName ?: throw
                PulumiNullFieldException("applicationGatewayName"),
            connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
