@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetAzureFirewallPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureFirewallName The name of the Azure Firewall.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetAzureFirewallPlainArgs(
    public val azureFirewallName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetAzureFirewallPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetAzureFirewallPlainArgs =
        com.pulumi.azurenative.network.inputs.GetAzureFirewallPlainArgs.builder()
            .azureFirewallName(azureFirewallName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureFirewallPlainArgs].
 */
@PulumiTagMarker
public class GetAzureFirewallPlainArgsBuilder internal constructor() {
    private var azureFirewallName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Azure Firewall.
     */
    @JvmName("tgefmrvlhxtsaait")
    public suspend fun azureFirewallName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureFirewallName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pbpgblenfshndfyx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAzureFirewallPlainArgs = GetAzureFirewallPlainArgs(
        azureFirewallName = azureFirewallName ?: throw PulumiNullFieldException("azureFirewallName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
