@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetConnectionMonitorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionMonitorName The name of the connection monitor.
 * @property networkWatcherName The name of the Network Watcher resource.
 * @property resourceGroupName The name of the resource group containing Network Watcher.
 */
public data class GetConnectionMonitorPlainArgs(
    public val connectionMonitorName: String,
    public val networkWatcherName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetConnectionMonitorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetConnectionMonitorPlainArgs =
        com.pulumi.azurenative.network.inputs.GetConnectionMonitorPlainArgs.builder()
            .connectionMonitorName(connectionMonitorName.let({ args0 -> args0 }))
            .networkWatcherName(networkWatcherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionMonitorPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionMonitorPlainArgsBuilder internal constructor() {
    private var connectionMonitorName: String? = null

    private var networkWatcherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the connection monitor.
     */
    @JvmName("ojstuplelpyianfr")
    public suspend fun connectionMonitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionMonitorName = mapped
    }

    /**
     * @param value The name of the Network Watcher resource.
     */
    @JvmName("xfsstnyxwdvavkgc")
    public suspend fun networkWatcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the resource group containing Network Watcher.
     */
    @JvmName("nxsdcbnmqaltfuvv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectionMonitorPlainArgs = GetConnectionMonitorPlainArgs(
        connectionMonitorName = connectionMonitorName ?: throw
            PulumiNullFieldException("connectionMonitorName"),
        networkWatcherName = networkWatcherName ?: throw PulumiNullFieldException("networkWatcherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
