@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetCustomIPPrefixPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customIpPrefixName The name of the custom IP prefix.
 * @property expand Expands referenced resources.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetCustomIPPrefixPlainArgs(
    public val customIpPrefixName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetCustomIPPrefixPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetCustomIPPrefixPlainArgs =
        com.pulumi.azurenative.network.inputs.GetCustomIPPrefixPlainArgs.builder()
            .customIpPrefixName(customIpPrefixName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomIPPrefixPlainArgs].
 */
@PulumiTagMarker
public class GetCustomIPPrefixPlainArgsBuilder internal constructor() {
    private var customIpPrefixName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the custom IP prefix.
     */
    @JvmName("ternxdyvjcpuivel")
    public suspend fun customIpPrefixName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customIpPrefixName = mapped
    }

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("twhaskiexvymbgmo")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("stheflasixpxomcm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCustomIPPrefixPlainArgs = GetCustomIPPrefixPlainArgs(
        customIpPrefixName = customIpPrefixName ?: throw PulumiNullFieldException("customIpPrefixName"),
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
