@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName The name of the Traffic Manager endpoint.
 * @property endpointType The type of the Traffic Manager endpoint.
 * @property profileName The name of the Traffic Manager profile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEndpointPlainArgs(
    public val endpointName: String,
    public val endpointType: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetEndpointPlainArgs =
        com.pulumi.azurenative.network.inputs.GetEndpointPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .endpointType(endpointType.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var endpointType: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Traffic Manager endpoint.
     */
    @JvmName("rsmugwdkwnyvrwtu")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The type of the Traffic Manager endpoint.
     */
    @JvmName("aygnggdfvumjwfum")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointType = mapped
    }

    /**
     * @param value The name of the Traffic Manager profile.
     */
    @JvmName("qydinrpawpxbfjoi")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hoqxygwecwkgjlvy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
